/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TransactionContextTest {
    TransactionContext underTest;
    static JDBCPersistenceAdapter jdbcPersistenceAdapter;

    @BeforeClass
    public static void init() throws Exception {
        jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        jdbcPersistenceAdapter.stop();
    }

    @Before
    public void setup() throws Exception {
        this.underTest = new TransactionContext(jdbcPersistenceAdapter, 0, 0);
    }

    @Test
    public void testCompletionCalledOnceOnCommmit() throws Exception {
        final AtomicInteger called = new AtomicInteger();
        this.underTest.begin();
        this.underTest.onCompletion(new Runnable(){

            @Override
            public void run() {
                called.incrementAndGet();
            }
        });
        this.underTest.commit();
        Assert.assertEquals((long)1L, (long)called.get());
        this.underTest.begin();
        this.underTest.commit();
        Assert.assertEquals((long)1L, (long)called.get());
    }

    @Test
    public void testCompletionCalledOnceOnClose() throws Exception {
        this.underTest.getConnection();
        final AtomicInteger called = new AtomicInteger();
        this.underTest.onCompletion(new Runnable(){

            @Override
            public void run() {
                called.incrementAndGet();
            }
        });
        this.underTest.close();
        Assert.assertEquals((long)1L, (long)called.get());
        this.underTest.getConnection();
        this.underTest.close();
        Assert.assertEquals((long)1L, (long)called.get());
    }
}

