/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.apache.activemq.network.BaseNetworkTest;
import org.apache.activemq.network.CustomNetworkBridgeFactory;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CustomBridgeFactoryTest
extends BaseNetworkTest {
    private ActiveMQQueue outgoing = new ActiveMQQueue("outgoing");

    @Test(timeout=10000L)
    public void verifyOutgoingCommunication() throws JMSException {
        CustomNetworkBridgeFactory bridgeFactory = this.getCustomNetworkBridgeFactory();
        NetworkBridgeListener listener = bridgeFactory.getListener();
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStart((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        this.send(this.localSession, this.outgoing, this.localSession.createTextMessage("test message"));
        Assert.assertNotNull((String)"Message didn't arrive", (Object)this.receive(this.remoteSession, this.outgoing));
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onOutboundMessage((NetworkBridge)Matchers.any(NetworkBridge.class), (Message)Matchers.any(Message.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test(timeout=10000L)
    public void verifyBrokerShutdown() {
        this.shutdownTest(() -> {
            try {
                this.localBroker.stop();
            }
            catch (Exception e) {
                return e;
            }
            return null;
        });
    }

    @Test(timeout=10000L)
    public void verifyConnectorShutdown() {
        this.shutdownTest(() -> {
            try {
                this.getLocalConnector(0).stop();
            }
            catch (Exception e) {
                return e;
            }
            return null;
        });
    }

    private void shutdownTest(Supplier<Throwable> callback) {
        CustomNetworkBridgeFactory bridgeFactory = this.getCustomNetworkBridgeFactory();
        NetworkBridgeListener listener = bridgeFactory.getListener();
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStart((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        Throwable throwable = callback.get();
        Assert.assertNull((String)"Unexpected error", (Object)throwable);
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStop((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Session session, ActiveMQQueue destination, TextMessage message) throws JMSException {
        try (MessageProducer producer = session.createProducer((Destination)destination);){
            producer.send((javax.jms.Message)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.jms.Message receive(Session session, ActiveMQQueue destination) throws JMSException {
        try (MessageConsumer consumer = session.createConsumer((Destination)destination);){
            javax.jms.Message message = consumer.receive(TimeUnit.SECONDS.toMillis(5L));
            return message;
        }
    }

    private CustomNetworkBridgeFactory getCustomNetworkBridgeFactory() {
        NetworkConnector connector = this.getLocalConnector(0);
        Assert.assertTrue((boolean)(connector.getBridgeFactory() instanceof CustomNetworkBridgeFactory));
        return (CustomNetworkBridgeFactory)connector.getBridgeFactory();
    }

    private NetworkConnector getLocalConnector(int index) {
        return (NetworkConnector)this.localBroker.getNetworkConnectors().get(index);
    }

    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker-custom-factory.xml";
    }
}

