/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Arrays;
import java.util.Collection;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AMQ6194Test {
    private boolean transaction;
    private BrokerService brokerService;
    private String connectionUri;

    @Parameterized.Parameters(name="transaction:{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false}, {true});
    }

    public AMQ6194Test(boolean transaction) {
        this.transaction = transaction;
    }

    @Before
    public void before() throws Exception {
        this.brokerService = new BrokerService();
        TransportConnector connector = this.brokerService.addConnector("tcp://localhost:0");
        this.connectionUri = connector.getPublishableConnectString();
        this.brokerService.setPersistent(false);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempStatistics() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        TemporaryQueue temporaryQueue = null;
        try {
            connection = factory.createConnection();
            connection.start();
            session = this.transaction ? connection.createSession(true, 0) : connection.createSession(false, 1);
            temporaryQueue = session.createTemporaryQueue();
            producer = session.createProducer((Destination)temporaryQueue);
            TextMessage textMessage = session.createTextMessage();
            textMessage.setText("Text Message");
            producer.send((Message)textMessage);
            if (this.transaction) {
                session.commit();
            }
            org.apache.activemq.broker.region.Destination dest = this.brokerService.getDestination((ActiveMQDestination)temporaryQueue);
            Assert.assertEquals((long)1L, (long)dest.getDestinationStatistics().getMessages().getCount());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

