/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.AbortSlowAckConsumerStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5421Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ5421Test.class);
    private static final int DEST_COUNT = 1000;
    private final Destination[] destination = new Destination[1000];
    private final MessageProducer[] producer = new MessageProducer[1000];
    private BrokerService brokerService;
    private String connectionUri;

    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory conFactory = new ActiveMQConnectionFactory(this.connectionUri);
        conFactory.setWatchTopicAdvisories(false);
        return conFactory;
    }

    protected AbortSlowAckConsumerStrategy createSlowConsumerStrategy() {
        AbortSlowAckConsumerStrategy strategy = new AbortSlowAckConsumerStrategy();
        strategy.setCheckPeriod(2000L);
        strategy.setMaxTimeSinceLastAck(5000L);
        strategy.setIgnoreIdleConsumers(false);
        return strategy;
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false&useJmx=true"));
        PolicyEntry policy = new PolicyEntry();
        policy.setSlowConsumerStrategy((SlowConsumerStrategy)this.createSlowConsumerStrategy());
        policy.setQueuePrefetch(10);
        policy.setTopicPrefetch(10);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.brokerService.setUseJmx(false);
        this.brokerService.setDestinationPolicy(pMap);
        this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
        this.connectionUri = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString();
    }

    @Test
    public void testManyTempDestinations() throws Exception {
        int i;
        Connection connection = this.createConnectionFactory().createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        for (i = 0; i < 1000; ++i) {
            this.destination[i] = session.createTemporaryQueue();
            LOG.debug("Created temp queue: [}", (Object)i);
        }
        for (i = 0; i < 1000; ++i) {
            this.producer[i] = session.createProducer(this.destination[i]);
            LOG.debug("Created producer: {}", (Object)i);
            TextMessage msg = session.createTextMessage(" testMessage " + i);
            this.producer[i].send((Message)msg);
            LOG.debug("message sent: {}", (Object)i);
            MessageConsumer consumer = session.createConsumer(this.destination[i]);
            Message message = consumer.receive(1000L);
            Assert.assertTrue((boolean)message.equals(msg));
        }
        for (i = 0; i < 1000; ++i) {
            this.producer[i].close();
        }
        connection.close();
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }
}

