/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.FixedCountSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.util.MessageIdList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class SimpleDispatchPolicyTest
extends QueueSubscriptionTest {
    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy((DispatchPolicy)new SimpleDispatchPolicy());
        policy.setSubscriptionRecoveryPolicy((SubscriptionRecoveryPolicy)new FixedCountSubscriptionRecoveryPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesLargePrefetch();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesLargePrefetch();
    }

    public void assertOneConsumerReceivedAllMessages(int messageCount) throws Exception {
        boolean found = false;
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(i.next()));
            int count = messageIdList.getMessageCount();
            if (count <= 0) continue;
            if (found) {
                Assert.fail((String)"No other consumers should have received any messages");
                continue;
            }
            Assert.assertEquals((String)"Consumer should have received all messages.", (long)messageCount, (long)count);
            found = true;
        }
        if (!found) {
            Assert.fail((String)"At least one consumer should have received all messages");
        }
    }
}

