/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.jms.InvalidDestinationException;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMXRemoveOfflineDurableSubscriberTest {
    private BrokerService broker;
    private static final String SUBSCRIBER_NAME = "testSubscriber";
    private static final String OFFLINE_CONNECTION_ID = "OFFLINE";
    private static final String TOPIC_NAME = "testTopic";

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("ActiveMQBroker");
        this.broker.setPersistent(false);
        this.broker.setUseVirtualTopics(false);
        this.broker.setUseJmx(true);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
    }

    @After
    public void teardown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testCreateOfflineDurableSubscriber() throws Exception {
        boolean subscriberAlreadyDeleted;
        block2: {
            this.broker.getAdminView().addTopic(TOPIC_NAME);
            this.broker.getAdminView().createDurableSubscriber(OFFLINE_CONNECTION_ID, SUBSCRIBER_NAME, TOPIC_NAME, null);
            this.broker.getAdminView().destroyDurableSubscriber(OFFLINE_CONNECTION_ID, SUBSCRIBER_NAME);
            subscriberAlreadyDeleted = false;
            try {
                this.broker.getAdminView().destroyDurableSubscriber(OFFLINE_CONNECTION_ID, SUBSCRIBER_NAME);
            }
            catch (InvalidDestinationException t) {
                if (!t.getMessage().equals("No durable subscription exists for clientID: OFFLINE and subscriptionName: testSubscriber")) break block2;
                subscriberAlreadyDeleted = true;
            }
        }
        Assert.assertTrue((boolean)subscriberAlreadyDeleted);
    }
}

