/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.net.URI;
import java.util.Set;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.xbean.XBeanBrokerFactory;

public class CreateDestinationsOnStartupViaXBeanTest
extends EmbeddedBrokerTestSupport {
    public void testNewDestinationsAreCreatedOnStartup() throws Exception {
        this.assertQueueCreated("FOO.BAR", true);
        this.assertQueueCreated("FOO.DoesNotExist", false);
        this.assertTopicCreated("SOME.TOPIC", true);
        this.assertTopicCreated("FOO.DoesNotExist", false);
    }

    protected void assertQueueCreated(String name, boolean expected) throws Exception {
        this.assertDestinationCreated((ActiveMQDestination)new ActiveMQQueue(name), expected);
    }

    protected void assertTopicCreated(String name, boolean expected) throws Exception {
        this.assertDestinationCreated((ActiveMQDestination)new ActiveMQTopic(name), expected);
    }

    protected void assertDestinationCreated(ActiveMQDestination destination, boolean expected) throws Exception {
        Set answer = this.broker.getBroker().getDestinations(destination);
        int size = expected ? 1 : 0;
        CreateDestinationsOnStartupViaXBeanTest.assertEquals((String)("Could not find destination: " + destination + ". Size of found destinations: " + answer), (int)size, (int)answer.size());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        answer.setPersistent(false);
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/destinations-on-start.xml";
    }
}

