/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AMQ6446Test {
    private BrokerService brokerService;
    LinkedList<Connection> connections = new LinkedList();

    @Test
    public void test2Connections() throws Exception {
        String urlTraceParam = "?trace=true";
        this.startBroker("?trace=true");
        final HashSet<String> loggers = new HashSet<String>();
        final HashSet<String> messages = new HashSet<String>();
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                loggers.add(event.getLoggerName());
                messages.add(event.getMessage().getFormattedMessage());
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        Configurator.setRootLevel((Level)Level.DEBUG);
        String brokerUrlWithTrace = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString() + "?trace=true";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrlWithTrace);
        for (int i = 0; i < 2; ++i) {
            Connection c = factory.createConnection();
            c.start();
            this.connections.add(c);
        }
        logger.removeAppender((Appender)appender);
        Assert.assertFalse((boolean)this.foundMatch(loggers, ".*:2$"));
        Assert.assertTrue((boolean)this.foundMatch(messages, "^0+\\d:.*"));
    }

    public boolean foundMatch(Collection<String> values, String regex) {
        String input;
        Matcher m;
        boolean found = false;
        Pattern p = Pattern.compile(regex);
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext() && !(found = (m = p.matcher(input = iterator.next())).matches())) {
        }
        return found;
    }

    @Test
    public void test2ConnectionsLegacy() throws Exception {
        String legacySupportParam = "?trace=true&jmxPort=22";
        this.startBroker("?trace=true&jmxPort=22");
        final HashSet<String> loggers = new HashSet<String>();
        final HashSet<String> messages = new HashSet<String>();
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                loggers.add(event.getLoggerName());
                messages.add(event.getMessage().getFormattedMessage());
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        Configurator.setRootLevel((Level)Level.TRACE);
        String brokerUrlWithTrace = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString() + "?trace=true&jmxPort=22";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrlWithTrace);
        for (int i = 0; i < 2; ++i) {
            Connection c = factory.createConnection();
            c.start();
            this.connections.add(c);
        }
        logger.removeAppender((Appender)appender);
        Assert.assertTrue((boolean)this.foundMatch(loggers, ".*:2$"));
        Assert.assertFalse((boolean)this.foundMatch(messages, "^0+\\d:.*"));
    }

    @After
    public void tearDown() throws Exception {
        for (Connection connection : this.connections) {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    public void startBroker(String urlParam) throws Exception {
        this.brokerService = BrokerFactory.createBroker((String)("broker:(tcp://0.0.0.0:0" + urlParam + ")/localhost?useJmx=false&persistent=false"));
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }
}

