/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.management.ObjectName;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DiscardingDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCCommitExceptionTest;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.TestUtils;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCXACommitExceptionTest
extends JDBCCommitExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCXACommitExceptionTest.class);
    protected ActiveMQXAConnectionFactory factory;
    boolean onePhase = true;
    final AtomicInteger getAutoCommitCount = new AtomicInteger();
    private ArrayList<Integer> getAutoCommitErrors = new ArrayList();
    private ArrayList<Integer> executeUpdateErrorOps = new ArrayList();
    final AtomicInteger executeUpdateErrorOpsCount = new AtomicInteger();
    private ArrayList<Integer> executeBatchErrorOps = new ArrayList();
    final AtomicInteger executeBatchErrorOpsCount = new AtomicInteger();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.onePhase = true;
        this.factory = new ActiveMQXAConnectionFactory(this.connectionUri + "?jms.prefetchPolicy.all=0&jms.redeliveryPolicy.maximumRedeliveries=10");
    }

    public void testTwoPhaseSqlException() throws Exception {
        this.onePhase = false;
        this.doTestSqlException();
    }

    @Override
    protected int receiveMessages(int messagesExpected) throws Exception {
        XAConnection connection = this.factory.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        this.jdbc.setShouldBreak(true);
        this.receiveMessages(messagesExpected, session, this.onePhase);
        this.jdbc.setShouldBreak(false);
        return this.receiveMessages(messagesExpected, session, this.onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int receiveMessages(int messagesExpected, XASession session, boolean onePhase) throws Exception {
        int messagesReceived = 0;
        for (int i = 0; i < messagesExpected; ++i) {
            Queue destination = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            XAResource resource = session.getXAResource();
            resource.recover(0x1000000);
            resource.recover(0);
            Xid tid = TestUtils.createXid();
            Message message = null;
            try {
                LOG.debug("Receiving message " + (messagesReceived + 1) + " of " + messagesExpected);
                resource.start(tid, 0);
                message = consumer.receive(2000L);
                LOG.info("Received : " + message);
                resource.end(tid, 0x4000000);
                if (message == null) continue;
                if (onePhase) {
                    resource.commit(tid, true);
                } else {
                    resource.prepare(tid);
                    resource.commit(tid, false);
                }
                ++messagesReceived;
                continue;
            }
            catch (Exception e) {
                LOG.debug("Caught exception:", (Throwable)e);
                try {
                    LOG.debug("Rolling back transaction (just in case, no need to do this as it is implicit in a 1pc commit failure) " + tid);
                    resource.rollback(tid);
                }
                catch (XAException ex) {
                    try {
                        LOG.debug("Caught exception during rollback: " + ex + " forgetting transaction " + tid);
                        resource.forget(tid);
                    }
                    catch (XAException ex1) {
                        LOG.debug("rollback/forget failed: " + ex1.errorCode);
                    }
                }
                continue;
            }
            finally {
                if (consumer != null) {
                    consumer.close();
                }
            }
        }
        return messagesReceived;
    }

    public void testCommitSendErrorRecovery() throws Exception {
        XAConnection connection = this.factory.createXAConnection();
        connection.start();
        XASession session = connection.createXASession();
        Queue destination = session.createQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        XAResource resource = session.getXAResource();
        Xid tid = TestUtils.createXid();
        resource.start(tid, 0);
        ActiveMQMessage message = (ActiveMQMessage)session.createMessage();
        message.setTransactionId((TransactionId)new XATransactionId(tid));
        producer.send((Message)message);
        resource.end(tid, 0x4000000);
        resource.prepare(tid);
        this.jdbc.setShouldBreak(true);
        try {
            resource.commit(tid, true);
        }
        catch (Exception expected) {
            expected.printStackTrace();
        }
        Xid[] recovered = resource.recover(0x1000000);
        resource.recover(0);
        this.jdbc.setShouldBreak(false);
        resource.commit(recovered[0], false);
        JDBCXACommitExceptionTest.assertEquals((String)"one enque", (long)1L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getEnqueues().getCount());
    }

    public void testXAEnqueueErrors() throws Exception {
        this.getAutoCommitCount.set(0);
        this.getAutoCommitErrors.clear();
        this.executeUpdateErrorOpsCount.set(0);
        this.executeUpdateErrorOps.clear();
        this.broker.stop();
        this.broker = new BrokerService();
        this.broker.setAdvisorySupport(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setExpireMessagesPeriod(0L);
        policyMap.setDefaultEntry(policyEntry);
        this.broker.setDestinationPolicy(policyMap);
        JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
        DataSource realDataSource = this.jdbc.getDataSource();
        jdbcPersistenceAdapter.setDataSource((DataSource)new TestDataSource(realDataSource));
        jdbcPersistenceAdapter.setUseLock(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)jdbcPersistenceAdapter);
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.executeUpdateErrorOps.add(5);
        this.executeUpdateErrorOps.add(9);
        this.executeUpdateErrorOps.add(12);
        this.getAutoCommitErrors.add(61);
        this.getAutoCommitErrors.add(62);
        this.factory = new ActiveMQXAConnectionFactory(this.connectionUri);
        XAConnection c = this.factory.createXAConnection();
        c.start();
        XASession s = c.createXASession();
        XAResource recoveryResource = s.getXAResource();
        for (int i = 0; i < 10; ++i) {
            XAConnection connection = this.factory.createXAConnection();
            connection.start();
            XASession session = connection.createXASession();
            Queue destination = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)destination);
            XAResource resource = session.getXAResource();
            Xid tid = TestUtils.createXid();
            resource.start(tid, 0);
            ActiveMQMessage message = (ActiveMQMessage)session.createMessage();
            message.setTransactionId((TransactionId)new XATransactionId(tid));
            producer.send((Message)message);
            resource.end(tid, 0x4000000);
            resource.prepare(tid);
            try {
                resource.commit(tid, false);
                continue;
            }
            catch (Exception expected) {
                expected.printStackTrace();
                this.dumpMessages();
                boolean done = false;
                while (!done) {
                    Xid[] recovered = recoveryResource.recover(0x1000000);
                    recoveryResource.recover(0);
                    try {
                        recoveryResource.commit(recovered[0], false);
                        done = true;
                    }
                    catch (XAException ok) {
                        ok.printStackTrace();
                    }
                }
            }
        }
        this.dumpMessages();
        JDBCXACommitExceptionTest.assertEquals((String)"en-queue", (long)10L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getEnqueues().getCount());
        JDBCXACommitExceptionTest.assertEquals((String)"en-queue", (long)10L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getMessages().getCount());
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        JDBCXACommitExceptionTest.assertEquals((String)"qs", (long)10L, (long)proxy.getQueueSize());
        JDBCXACommitExceptionTest.assertEquals((String)"enq", (long)10L, (long)proxy.getEnqueueCount());
        JDBCXACommitExceptionTest.assertEquals((String)"curs", (int)10, (int)proxy.cursorSize());
    }

    public void testNonTxEnqueueErrors() throws Exception {
        this.getAutoCommitCount.set(0);
        this.getAutoCommitErrors.clear();
        this.executeUpdateErrorOpsCount.set(0);
        this.executeUpdateErrorOps.clear();
        this.executeBatchErrorOps.clear();
        this.executeBatchErrorOpsCount.set(0);
        this.broker.stop();
        this.broker = new BrokerService();
        this.broker.setAdvisorySupport(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setExpireMessagesPeriod(0L);
        policyMap.setDefaultEntry(policyEntry);
        this.broker.setDestinationPolicy(policyMap);
        JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
        DataSource realDataSource = this.jdbc.getDataSource();
        jdbcPersistenceAdapter.setDataSource((DataSource)new TestDataSource(realDataSource));
        jdbcPersistenceAdapter.setUseLock(false);
        jdbcPersistenceAdapter.setCleanupPeriod(0);
        this.broker.setPersistenceAdapter((PersistenceAdapter)jdbcPersistenceAdapter);
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.executeBatchErrorOps.add(2);
        this.executeBatchErrorOps.add(3);
        this.getAutoCommitCount.set(0);
        this.getAutoCommitErrors.add(10);
        ActiveMQConnectionFactory nonTxFactory = new ActiveMQConnectionFactory(this.connectionUri);
        for (int i = 0; i < 10; ++i) {
            Connection connection = nonTxFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)destination);
            ActiveMQMessage message = (ActiveMQMessage)session.createMessage();
            try {
                producer.send((Message)message);
                continue;
            }
            catch (Exception expected) {
                expected.printStackTrace();
                this.dumpMessages();
                boolean done = false;
                while (!done) {
                    try {
                        producer.send((Message)message);
                        done = true;
                    }
                    catch (Exception ok) {
                        ok.printStackTrace();
                    }
                }
            }
        }
        JDBCXACommitExceptionTest.assertEquals((String)"messages in db", (int)10, (int)this.dumpMessages());
        JDBCXACommitExceptionTest.assertEquals((String)"en-queue", (long)10L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getEnqueues().getCount());
        JDBCXACommitExceptionTest.assertEquals((String)"en-queue", (long)10L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getMessages().getCount());
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        JDBCXACommitExceptionTest.assertEquals((String)"qs", (long)10L, (long)proxy.getQueueSize());
        JDBCXACommitExceptionTest.assertEquals((String)"enq", (long)10L, (long)proxy.getEnqueueCount());
        JDBCXACommitExceptionTest.assertEquals((String)"curs", (int)10, (int)proxy.cursorSize());
    }

    public void testNonTxEnqueueOverNetworkErrorsRestart() throws Exception {
        this.getAutoCommitCount.set(0);
        this.getAutoCommitErrors.clear();
        this.executeUpdateErrorOpsCount.set(0);
        this.executeUpdateErrorOps.clear();
        this.executeBatchErrorOps.clear();
        this.executeBatchErrorOpsCount.set(0);
        this.broker.stop();
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!done.get()) {
                    try {
                        JDBCXACommitExceptionTest.this.broker = new BrokerService();
                        JDBCXACommitExceptionTest.this.broker.setAdvisorySupport(false);
                        PolicyMap policyMap = new PolicyMap();
                        PolicyEntry policyEntry = new PolicyEntry();
                        policyEntry.setUseCache(false);
                        policyEntry.setExpireMessagesPeriod(0L);
                        policyEntry.setDeadLetterStrategy((DeadLetterStrategy)new DiscardingDeadLetterStrategy());
                        policyMap.setDefaultEntry(policyEntry);
                        JDBCXACommitExceptionTest.this.broker.setDestinationPolicy(policyMap);
                        JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
                        DataSource realDataSource = JDBCXACommitExceptionTest.this.jdbc.getDataSource();
                        jdbcPersistenceAdapter.setDataSource((DataSource)new TestDataSource(realDataSource));
                        jdbcPersistenceAdapter.setUseLock(false);
                        jdbcPersistenceAdapter.setCleanupPeriod(0);
                        JDBCXACommitExceptionTest.this.broker.setPersistenceAdapter((PersistenceAdapter)jdbcPersistenceAdapter);
                        TransportConnector transportConnector = JDBCXACommitExceptionTest.this.broker.addConnector("tcp://localhost:61616");
                        JDBCXACommitExceptionTest.this.connectionUri = transportConnector.getPublishableConnectString();
                        DefaultIOExceptionHandler stopOnIOEx = new DefaultIOExceptionHandler();
                        stopOnIOEx.setIgnoreSQLExceptions(false);
                        stopOnIOEx.setStopStartConnectors(false);
                        JDBCXACommitExceptionTest.this.broker.setIoExceptionHandler((IOExceptionHandler)stopOnIOEx);
                        JDBCXACommitExceptionTest.this.broker.start();
                        JDBCXACommitExceptionTest.this.broker.waitUntilStopped();
                    }
                    catch (Exception oops) {
                        oops.printStackTrace();
                        done.set(true);
                    }
                }
            }
        };
        thread.start();
        this.getAutoCommitCount.set(0);
        this.getAutoCommitErrors.add(39);
        final BrokerService other = new BrokerService();
        other.setBrokerName("other");
        other.setAdvisorySupport(false);
        other.setUseJmx(false);
        other.setPersistent(false);
        NetworkConnector netwokConnector = other.addNetworkConnector("static://tcp://localhost:61616");
        netwokConnector.setStaticBridge(true);
        netwokConnector.setStaticallyIncludedDestinations(Arrays.asList(new ActiveMQQueue("TEST")));
        other.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://other");
        ActiveMQConnection activeMQConnection = (ActiveMQConnection)connectionFactory.createConnection();
        activeMQConnection.setWatchTopicAdvisories(false);
        Session session = activeMQConnection.createSession(false, 1);
        activeMQConnection.start();
        Queue destination = session.createQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        ActiveMQMessage message = (ActiveMQMessage)session.createMessage();
        for (int i = 0; i < 10; ++i) {
            producer.send((Message)message);
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("MESSAGES DRAINED :" + ((RegionBroker)other.getRegionBroker()).getDestinationStatistics().getMessages().getCount());
                return 0L == ((RegionBroker)other.getRegionBroker()).getDestinationStatistics().getMessages().getCount();
            }
        });
        activeMQConnection.close();
        JDBCXACommitExceptionTest.assertEquals((String)"db", (int)10, (int)this.dumpMessages());
        JDBCXACommitExceptionTest.assertEquals((String)"messages count", (long)10L, (long)((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().getMessages().getCount());
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        JDBCXACommitExceptionTest.assertEquals((String)"qs", (long)10L, (long)proxy.getQueueSize());
        JDBCXACommitExceptionTest.assertEquals((String)"curs", (int)10, (int)proxy.cursorSize());
        done.set(true);
        other.stop();
    }

    private class AutoCommitCheckConnection
    implements java.sql.Connection {
        private final java.sql.Connection realConnection;

        public AutoCommitCheckConnection(java.sql.Connection connection) {
            this.realConnection = connection;
        }

        @Override
        public void commit() throws SQLException {
            this.realConnection.commit();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.realConnection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            final PreparedStatement delegate = this.realConnection.prepareStatement(sql);
            return new PreparedStatement(){

                @Override
                public ResultSet executeQuery() throws SQLException {
                    return delegate.executeQuery();
                }

                @Override
                public final int executeUpdate() throws SQLException {
                    int ret = delegate.executeUpdate();
                    if (JDBCXACommitExceptionTest.this.executeUpdateErrorOps.contains(JDBCXACommitExceptionTest.this.executeUpdateErrorOpsCount.incrementAndGet())) {
                        throw new SQLRecoverableException("SOME executeUpdate ERROR[" + JDBCXACommitExceptionTest.this.executeUpdateErrorOpsCount.get() + "]");
                    }
                    return ret;
                }

                @Override
                public void setNull(int parameterIndex, int sqlType) throws SQLException {
                    delegate.setNull(parameterIndex, sqlType);
                }

                @Override
                public void setBoolean(int parameterIndex, boolean x) throws SQLException {
                    delegate.setBoolean(parameterIndex, x);
                }

                @Override
                public void setByte(int parameterIndex, byte x) throws SQLException {
                    delegate.setByte(parameterIndex, x);
                }

                @Override
                public void setShort(int parameterIndex, short x) throws SQLException {
                    delegate.setShort(parameterIndex, x);
                }

                @Override
                public void setInt(int parameterIndex, int x) throws SQLException {
                    delegate.setInt(parameterIndex, x);
                }

                @Override
                public void setLong(int parameterIndex, long x) throws SQLException {
                    delegate.setLong(parameterIndex, x);
                }

                @Override
                public void setFloat(int parameterIndex, float x) throws SQLException {
                    delegate.setFloat(parameterIndex, x);
                }

                @Override
                public void setDouble(int parameterIndex, double x) throws SQLException {
                    delegate.setDouble(parameterIndex, x);
                }

                @Override
                public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
                    delegate.setBigDecimal(parameterIndex, x);
                }

                @Override
                public void setString(int parameterIndex, String x) throws SQLException {
                    delegate.setString(parameterIndex, x);
                }

                @Override
                public void setBytes(int parameterIndex, byte[] x) throws SQLException {
                    delegate.setBytes(parameterIndex, x);
                }

                @Override
                public void setDate(int parameterIndex, Date x) throws SQLException {
                    delegate.setDate(parameterIndex, x);
                }

                @Override
                public void setTime(int parameterIndex, Time x) throws SQLException {
                    delegate.setTime(parameterIndex, x);
                }

                @Override
                public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
                    delegate.setTimestamp(parameterIndex, x);
                }

                @Override
                public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
                    delegate.setAsciiStream(parameterIndex, x, length);
                }

                @Override
                @Deprecated
                public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
                    delegate.setUnicodeStream(parameterIndex, x, length);
                }

                @Override
                public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
                    delegate.setBinaryStream(parameterIndex, x, length);
                }

                @Override
                public void clearParameters() throws SQLException {
                    delegate.clearParameters();
                }

                @Override
                public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
                    delegate.setObject(parameterIndex, x, targetSqlType);
                }

                @Override
                public void setObject(int parameterIndex, Object x) throws SQLException {
                    delegate.setObject(parameterIndex, x);
                }

                @Override
                public boolean execute() throws SQLException {
                    return delegate.execute();
                }

                @Override
                public void addBatch() throws SQLException {
                    delegate.addBatch();
                }

                @Override
                public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
                    delegate.setCharacterStream(parameterIndex, reader, length);
                }

                @Override
                public void setRef(int parameterIndex, Ref x) throws SQLException {
                    delegate.setRef(parameterIndex, x);
                }

                @Override
                public void setBlob(int parameterIndex, Blob x) throws SQLException {
                    delegate.setBlob(parameterIndex, x);
                }

                @Override
                public void setClob(int parameterIndex, Clob x) throws SQLException {
                    delegate.setClob(parameterIndex, x);
                }

                @Override
                public void setArray(int parameterIndex, Array x) throws SQLException {
                    delegate.setArray(parameterIndex, x);
                }

                @Override
                public ResultSetMetaData getMetaData() throws SQLException {
                    return delegate.getMetaData();
                }

                @Override
                public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
                    delegate.setDate(parameterIndex, x, cal);
                }

                @Override
                public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
                    delegate.setTime(parameterIndex, x, cal);
                }

                @Override
                public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
                    delegate.setTimestamp(parameterIndex, x, cal);
                }

                @Override
                public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
                    delegate.setNull(parameterIndex, sqlType, typeName);
                }

                @Override
                public void setURL(int parameterIndex, URL x) throws SQLException {
                    delegate.setURL(parameterIndex, x);
                }

                @Override
                public ParameterMetaData getParameterMetaData() throws SQLException {
                    return delegate.getParameterMetaData();
                }

                @Override
                public void setRowId(int parameterIndex, RowId x) throws SQLException {
                    delegate.setRowId(parameterIndex, x);
                }

                @Override
                public void setNString(int parameterIndex, String value) throws SQLException {
                    delegate.setNString(parameterIndex, value);
                }

                @Override
                public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
                    delegate.setNCharacterStream(parameterIndex, value, length);
                }

                @Override
                public void setNClob(int parameterIndex, NClob value) throws SQLException {
                    delegate.setNClob(parameterIndex, value);
                }

                @Override
                public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
                    delegate.setClob(parameterIndex, reader, length);
                }

                @Override
                public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
                    delegate.setBlob(parameterIndex, inputStream, length);
                }

                @Override
                public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
                    delegate.setNClob(parameterIndex, reader, length);
                }

                @Override
                public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
                    delegate.setSQLXML(parameterIndex, xmlObject);
                }

                @Override
                public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
                    delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
                }

                @Override
                public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
                    delegate.setAsciiStream(parameterIndex, x, length);
                }

                @Override
                public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
                    delegate.setBinaryStream(parameterIndex, x, length);
                }

                @Override
                public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
                    delegate.setCharacterStream(parameterIndex, reader, length);
                }

                @Override
                public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
                    delegate.setAsciiStream(parameterIndex, x);
                }

                @Override
                public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
                    delegate.setBinaryStream(parameterIndex, x);
                }

                @Override
                public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
                    delegate.setCharacterStream(parameterIndex, reader);
                }

                @Override
                public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
                    delegate.setNCharacterStream(parameterIndex, value);
                }

                @Override
                public void setClob(int parameterIndex, Reader reader) throws SQLException {
                    delegate.setClob(parameterIndex, reader);
                }

                @Override
                public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
                    delegate.setBlob(parameterIndex, inputStream);
                }

                @Override
                public void setNClob(int parameterIndex, Reader reader) throws SQLException {
                    delegate.setNClob(parameterIndex, reader);
                }

                @Override
                public ResultSet executeQuery(String sql) throws SQLException {
                    return delegate.executeQuery(sql);
                }

                @Override
                public int executeUpdate(String sql) throws SQLException {
                    return delegate.executeUpdate(sql);
                }

                @Override
                public void close() throws SQLException {
                    delegate.close();
                }

                @Override
                public int getMaxFieldSize() throws SQLException {
                    return delegate.getMaxFieldSize();
                }

                @Override
                public void setMaxFieldSize(int max) throws SQLException {
                    delegate.setMaxFieldSize(max);
                }

                @Override
                public int getMaxRows() throws SQLException {
                    return delegate.getMaxRows();
                }

                @Override
                public void setMaxRows(int max) throws SQLException {
                    delegate.setMaxRows(max);
                }

                @Override
                public void setEscapeProcessing(boolean enable) throws SQLException {
                    delegate.setEscapeProcessing(enable);
                }

                @Override
                public int getQueryTimeout() throws SQLException {
                    return delegate.getQueryTimeout();
                }

                @Override
                public void setQueryTimeout(int seconds) throws SQLException {
                    delegate.setQueryTimeout(seconds);
                }

                @Override
                public void cancel() throws SQLException {
                    delegate.cancel();
                }

                @Override
                public SQLWarning getWarnings() throws SQLException {
                    return delegate.getWarnings();
                }

                @Override
                public void clearWarnings() throws SQLException {
                    delegate.clearWarnings();
                }

                @Override
                public void setCursorName(String name) throws SQLException {
                    delegate.setCursorName(name);
                }

                @Override
                public boolean execute(String sql) throws SQLException {
                    return delegate.execute(sql);
                }

                @Override
                public ResultSet getResultSet() throws SQLException {
                    return delegate.getResultSet();
                }

                @Override
                public int getUpdateCount() throws SQLException {
                    return delegate.getUpdateCount();
                }

                @Override
                public boolean getMoreResults() throws SQLException {
                    return delegate.getMoreResults();
                }

                @Override
                public void setFetchDirection(int direction) throws SQLException {
                    delegate.setFetchDirection(direction);
                }

                @Override
                public int getFetchDirection() throws SQLException {
                    return delegate.getFetchDirection();
                }

                @Override
                public void setFetchSize(int rows) throws SQLException {
                    delegate.setFetchSize(rows);
                }

                @Override
                public int getFetchSize() throws SQLException {
                    return delegate.getFetchSize();
                }

                @Override
                public int getResultSetConcurrency() throws SQLException {
                    return delegate.getResultSetConcurrency();
                }

                @Override
                public int getResultSetType() throws SQLException {
                    return delegate.getResultSetType();
                }

                @Override
                public void addBatch(String sql) throws SQLException {
                    delegate.addBatch(sql);
                }

                @Override
                public void clearBatch() throws SQLException {
                    delegate.clearBatch();
                }

                @Override
                public int[] executeBatch() throws SQLException {
                    if (JDBCXACommitExceptionTest.this.executeBatchErrorOps.contains(JDBCXACommitExceptionTest.this.executeBatchErrorOpsCount.incrementAndGet())) {
                        throw new SQLRecoverableException("SOME executeBatch ERROR[" + JDBCXACommitExceptionTest.this.executeBatchErrorOpsCount.get() + "]");
                    }
                    return delegate.executeBatch();
                }

                @Override
                public java.sql.Connection getConnection() throws SQLException {
                    return delegate.getConnection();
                }

                @Override
                public boolean getMoreResults(int current) throws SQLException {
                    return delegate.getMoreResults(current);
                }

                @Override
                public ResultSet getGeneratedKeys() throws SQLException {
                    return delegate.getGeneratedKeys();
                }

                @Override
                public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
                    return delegate.executeUpdate(sql, autoGeneratedKeys);
                }

                @Override
                public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
                    return delegate.executeUpdate(sql, columnIndexes);
                }

                @Override
                public int executeUpdate(String sql, String[] columnNames) throws SQLException {
                    return delegate.executeUpdate(sql, columnNames);
                }

                @Override
                public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
                    return delegate.execute(sql, autoGeneratedKeys);
                }

                @Override
                public boolean execute(String sql, int[] columnIndexes) throws SQLException {
                    return delegate.execute(sql, columnIndexes);
                }

                @Override
                public boolean execute(String sql, String[] columnNames) throws SQLException {
                    return delegate.execute(sql, columnNames);
                }

                @Override
                public int getResultSetHoldability() throws SQLException {
                    return delegate.getResultSetHoldability();
                }

                @Override
                public boolean isClosed() throws SQLException {
                    return delegate.isClosed();
                }

                @Override
                public void setPoolable(boolean poolable) throws SQLException {
                    delegate.setPoolable(poolable);
                }

                @Override
                public boolean isPoolable() throws SQLException {
                    return delegate.isPoolable();
                }

                @Override
                public void closeOnCompletion() throws SQLException {
                    delegate.closeOnCompletion();
                }

                @Override
                public boolean isCloseOnCompletion() throws SQLException {
                    return delegate.isCloseOnCompletion();
                }

                @Override
                public <T> T unwrap(Class<T> iface) throws SQLException {
                    return delegate.unwrap(iface);
                }

                @Override
                public boolean isWrapperFor(Class<?> iface) throws SQLException {
                    return delegate.isWrapperFor(iface);
                }
            };
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.realConnection.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.realConnection.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.realConnection.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            if (JDBCXACommitExceptionTest.this.getAutoCommitErrors.contains(JDBCXACommitExceptionTest.this.getAutoCommitCount.incrementAndGet())) {
                throw new SQLRecoverableException("AutoCommit[" + JDBCXACommitExceptionTest.this.getAutoCommitCount.get() + "]");
            }
            return this.realConnection.getAutoCommit();
        }

        @Override
        public void rollback() throws SQLException {
            this.realConnection.rollback();
        }

        @Override
        public void close() throws SQLException {
            this.realConnection.close();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.realConnection.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.realConnection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.realConnection.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.realConnection.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.realConnection.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.realConnection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.realConnection.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.realConnection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.realConnection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.realConnection.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.realConnection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.realConnection.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.realConnection.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.realConnection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.realConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.realConnection.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.realConnection.rollback();
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.realConnection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.realConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.realConnection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.realConnection.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.realConnection.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.realConnection.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.realConnection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.realConnection.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.realConnection.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.realConnection.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.realConnection.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.realConnection.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.realConnection.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.realConnection.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.realConnection.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.realConnection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.realConnection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.realConnection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.realConnection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.realConnection.getNetworkTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.realConnection.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.realConnection.isWrapperFor(iface);
        }
    }

    private class TestDataSource
    implements DataSource {
        private final DataSource realDataSource;

        public TestDataSource(DataSource dataSource) {
            this.realDataSource = dataSource;
        }

        @Override
        public java.sql.Connection getConnection() throws SQLException {
            AutoCommitCheckConnection autoCommitCheckConnection = new AutoCommitCheckConnection(this.realDataSource.getConnection());
            return autoCommitCheckConnection;
        }

        @Override
        public java.sql.Connection getConnection(String username, String password) throws SQLException {
            AutoCommitCheckConnection autoCommitCheckConnection = new AutoCommitCheckConnection(this.realDataSource.getConnection(username, password));
            return autoCommitCheckConnection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.realDataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.realDataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.realDataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.realDataSource.getLoginTimeout();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.realDataSource.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.realDataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.realDataSource.isWrapperFor(iface);
        }
    }
}

