/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.Message;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.util.ByteSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTablePrefixAssignedTest {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCTablePrefixAssignedTest.class);
    private BrokerService service;

    @Before
    public void setUp() throws Exception {
        this.service = this.createBroker();
        this.service.start();
        this.service.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.service.stop();
        this.service.waitUntilStopped();
    }

    @Test
    public void testTablesHave() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost?create=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 0; i < 10; ++i) {
            producer.send((javax.jms.Message)session.createTextMessage("test"));
        }
        producer.close();
        connection.close();
        List<Message> queuedMessages = null;
        try {
            queuedMessages = this.dumpMessages();
        }
        catch (Exception ex) {
            LOG.info("Caught ex: ", (Throwable)ex);
            Assert.fail((String)"Should not have thrown an exception");
        }
        Assert.assertNotNull(queuedMessages);
        Assert.assertEquals((String)"Should have found 10 messages", (long)10L, (long)queuedMessages.size());
    }

    protected List<Message> dumpMessages() throws Exception {
        OpenWireFormat wireFormat = new OpenWireFormat();
        Connection conn = ((JDBCPersistenceAdapter)this.service.getPersistenceAdapter()).getDataSource().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT ID, MSG FROM MYPREFIX_ACTIVEMQ_MSGS");
        ResultSet result = statement.executeQuery();
        ArrayList<Message> results = new ArrayList<Message>();
        while (result.next()) {
            long id = result.getLong(1);
            Message message = (Message)wireFormat.unmarshal(new ByteSequence(result.getBytes(2)));
            LOG.info("id: " + id + ", message SeqId: " + message.getMessageId().getBrokerSequenceId() + ", MSG: " + message);
            results.add(message);
        }
        statement.close();
        conn.close();
        return results;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        DefaultJDBCAdapter adapter = new DefaultJDBCAdapter();
        jdbc.setAdapter((JDBCAdapter)adapter);
        Statements statements = new Statements();
        statements.setTablePrefix("MYPREFIX_");
        jdbc.setStatements(statements);
        jdbc.setUseLock(false);
        jdbc.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        return broker;
    }
}

