/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.sql.DataSource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.junit.Assert;
import org.junit.Test;

public class JDBCStoreAutoCommitTest {
    private static final String BROKER_NAME = "AutoCommitTest";
    private static final String TEST_DEST = "commitCheck";
    private static final String MSG_TEXT = "JDBCStoreAutoCommitTest TEST";
    DataSource realDataSource;

    @Test
    public void testDeleteAllMessages() throws Exception {
        BrokerService broker = this.createBrokerService();
        broker.getPersistenceAdapter().deleteAllMessages();
        broker.setUseJmx(false);
        broker.start();
        broker.waitUntilStarted();
        broker.stop();
        broker.waitUntilStopped();
    }

    @Test
    public void testSendConsume() throws Exception {
        this.doSendConsume(false);
    }

    @Test
    public void testSendConsumeTransacted() throws Exception {
        this.doSendConsume(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendConsume(boolean transacted) throws Exception {
        BrokerService broker = this.createBrokerService();
        broker.setUseJmx(false);
        broker.start();
        broker.waitUntilStarted();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI("vm:AutoCommitTest"));
        ActiveMQConnection c1 = (ActiveMQConnection)cf.createConnection();
        c1.start();
        try {
            Session session1 = c1.createSession(transacted, 1);
            MessageProducer messageProducer = session1.createProducer((Destination)session1.createQueue(TEST_DEST));
            TextMessage textMessage = session1.createTextMessage(MSG_TEXT);
            messageProducer.send((Message)textMessage);
            if (transacted) {
                session1.commit();
            }
            Session session2 = c1.createSession(transacted, 1);
            MessageConsumer messageConsumer = session2.createConsumer((Destination)session2.createQueue(TEST_DEST));
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(1000L);
            Assert.assertEquals((String)"check message received", (Object)MSG_TEXT, (Object)messageReceived.getText());
        }
        finally {
            c1.close();
            broker.stop();
            broker.waitUntilStopped();
            if (this.realDataSource != null) {
                DataSourceServiceSupport.shutdownDefaultDataSource((DataSource)this.realDataSource);
            }
        }
    }

    private BrokerService createBrokerService() throws IOException {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(BROKER_NAME);
        broker.setUseJmx(false);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        this.realDataSource = jdbc.getDataSource();
        jdbc.setDataSource((DataSource)new TestDataSource(this.realDataSource));
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        return broker;
    }

    private class AutoCommitCheckConnection
    implements Connection {
        private final Connection realConnection;

        public AutoCommitCheckConnection(Connection connection) {
            this.realConnection = connection;
        }

        @Override
        public void commit() throws SQLException {
            if (this.getAutoCommit()) {
                throw new SQLException("AutoCommitCheckConnection: Called commit on autoCommit Connection");
            }
            this.realConnection.commit();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.realConnection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.realConnection.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.realConnection.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.realConnection.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.realConnection.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.realConnection.getAutoCommit();
        }

        @Override
        public void rollback() throws SQLException {
            this.realConnection.rollback();
        }

        @Override
        public void close() throws SQLException {
            this.realConnection.close();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.realConnection.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.realConnection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.realConnection.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.realConnection.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.realConnection.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.realConnection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.realConnection.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.realConnection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.realConnection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.realConnection.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.realConnection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.realConnection.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.realConnection.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.realConnection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.realConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.realConnection.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.realConnection.rollback();
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.realConnection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.realConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.realConnection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.realConnection.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.realConnection.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.realConnection.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.realConnection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.realConnection.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.realConnection.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.realConnection.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.realConnection.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.realConnection.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.realConnection.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.realConnection.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.realConnection.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.realConnection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.realConnection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.realConnection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.realConnection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.realConnection.getNetworkTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.realConnection.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.realConnection.isWrapperFor(iface);
        }
    }

    private class TestDataSource
    implements DataSource {
        private final DataSource realDataSource;

        public TestDataSource(DataSource dataSource) {
            this.realDataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            AutoCommitCheckConnection autoCommitCheckConnection = new AutoCommitCheckConnection(this.realDataSource.getConnection());
            return autoCommitCheckConnection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            AutoCommitCheckConnection autoCommitCheckConnection = new AutoCommitCheckConnection(this.realDataSource.getConnection(username, password));
            return autoCommitCheckConnection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.realDataSource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.realDataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.realDataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.realDataSource.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.realDataSource.getParentLogger();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.realDataSource.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.realDataSource.isWrapperFor(iface);
        }
    }
}

