/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.MessageDispatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageExpiryClientSideTest {
    private ActiveMQConnection connection;
    private BrokerService broker;
    private volatile Exception connectionError;

    @Before
    public void setUp() throws Exception {
        this.createBroker();
        this.connection = this.createConnection();
        this.connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                try {
                    MessageExpiryClientSideTest.this.connectionError = exception;
                    MessageExpiryClientSideTest.this.connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testConsumerReceivePrefetchOneRedeliveryZero() throws Exception {
        this.connection.getPrefetchPolicy().setQueuePrefetch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("timeout.test");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage("test Message");
        producer.send((Message)textMessage);
        session.close();
        session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(1000L);
        Assert.assertNull((Object)message);
        session.close();
        Assert.assertNull((Object)this.connectionError);
    }

    @Test(timeout=30000L)
    public void testConsumerReceivePrefetchZeroRedeliveryZero() throws Exception {
        this.connection.getPrefetchPolicy().setQueuePrefetch(0);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("timeout.test");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage("test Message");
        producer.send((Message)textMessage);
        session.close();
        session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(1000L);
        Assert.assertNull((Object)message);
        session.close();
        Assert.assertNull((Object)this.connectionError);
    }

    @Test(timeout=30000L)
    public void testQueueBrowserPrefetchZeroRedeliveryZero() throws Exception {
        this.connection.getPrefetchPolicy().setQueuePrefetch(0);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("timeout.test");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage("test Message");
        producer.send((Message)textMessage);
        session.close();
        session = this.connection.createSession(false, 1);
        QueueBrowser browser = session.createBrowser(queue);
        Message message = null;
        Enumeration enumeration = browser.getEnumeration();
        while (enumeration.hasMoreElements()) {
            message = (Message)enumeration.nextElement();
        }
        Assert.assertNull(message);
        session.close();
        Assert.assertNull((Object)this.connectionError);
    }

    @Test(timeout=30000L)
    public void testQueueBrowserPrefetchOneRedeliveryZero() throws Exception {
        this.connection.getPrefetchPolicy().setQueuePrefetch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("timeout.test");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage("test Message");
        producer.send((Message)textMessage);
        session.close();
        session = this.connection.createSession(false, 1);
        QueueBrowser browser = session.createBrowser(queue);
        Message message = null;
        Enumeration enumeration = browser.getEnumeration();
        while (enumeration.hasMoreElements()) {
            message = (Message)enumeration.nextElement();
        }
        Assert.assertNull(message);
        session.close();
        Assert.assertNull((Object)this.connectionError);
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){
                    private AtomicInteger counter;
                    {
                        this.counter = new AtomicInteger();
                    }

                    public void preProcessDispatch(MessageDispatch messageDispatch) {
                        if (this.counter.get() == 0 && messageDispatch.getDestination().getPhysicalName().contains("timeout.test")) {
                            messageDispatch.getMessage().setExpiration(System.currentTimeMillis() - 1000L);
                            this.counter.incrementAndGet();
                        }
                        super.preProcessDispatch(messageDispatch);
                    }
                };
            }
        }});
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }
}

