/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.JmsUtils;

public class AMQ5486Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ5486Test.class);
    private static final int maxConnections = 100;
    private static final int maxPoolSize = 10;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private String connectionUri;
    private BrokerService service;
    private TransportConnector connector;
    final ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.apache.activemq.transport.nio.SelectorManager.maximumPoolSize", String.valueOf(10));
        System.setProperty("org.apache.activemq.transport.nio.SelectorManager.workQueueCapacity", "0");
        System.setProperty("org.apache.activemq.transport.nio.SelectorManager.rejectWork", "true");
        this.service = new BrokerService();
        this.service.setPersistent(false);
        this.service.setUseJmx(false);
        this.connector = this.service.addConnector("nio://0.0.0.0:0");
        this.connectionUri = this.connector.getPublishableConnectString();
        this.service.start();
        this.service.waitUntilStarted();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    @Test
    public void testFailureOnSelectorThreadPoolExhaustion() throws Exception {
        final ConnectionFactory cf = this.createConnectionFactory();
        final CountDownLatch startupLatch = new CountDownLatch(1);
        final List exceptions = Collections.synchronizedList(new LinkedList());
        for (int i = 0; i < 100; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    ActiveMQConnection conn = null;
                    try {
                        startupLatch.await();
                        conn = (ActiveMQConnection)cf.createConnection();
                        conn.start();
                        AMQ5486Test.this.connections.add((Connection)conn);
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                        JmsUtils.closeConnection((Connection)conn);
                    }
                }
            });
        }
        Assert.assertEquals((long)0L, (long)this.connector.getConnections().size());
        startupLatch.countDown();
        final TransportConnector connector = this.connector;
        Assert.assertTrue((String)"Expected some exceptions", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !exceptions.isEmpty();
            }
        }));
        Assert.assertTrue((String)"Expected some connections, provided not all errored out", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Exceptions size: " + exceptions.size() + ", connections size: " + connector.getConnections().size());
                return exceptions.size() == 100 || connector.getConnections().size() > 0;
            }
        }));
        Assert.assertTrue((String)"Expected: connections or exceptions match attempts: 100", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Exceptions size: " + exceptions.size() + ", connections size: " + connector.getConnections().size());
                return connector.getConnections().size() + exceptions.size() == 100;
            }
        }));
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
        for (Connection connection : this.connections) {
            JmsUtils.closeConnection((Connection)connection);
        }
        this.connections.clear();
        this.service.stop();
        this.service.waitUntilStopped();
    }
}

