/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkBridgeStatistics;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.transport.discovery.simple.SimpleDiscoveryAgent;
import org.junit.Assert;

public class AMQ4160Test
extends JmsMultipleBrokersTestSupport {
    final long MAX_TEST_TIME = TimeUnit.MINUTES.toMillis(2L);

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        this.setMaxTestTime(this.MAX_TEST_TIME);
        super.setUp();
    }

    public void testLostActiveBridge() throws Exception {
        final long ATTEMPT_TO_CREATE_DELAY = TimeUnit.SECONDS.toMillis(15L);
        BrokerService broker1 = this.createBroker(new URI("broker:(vm://broker1)/broker1?persistent=false"));
        final BrokerService broker2 = this.createBroker(new URI("broker:(vm://broker2)/broker2?persistent=false"));
        BrokerPlugin ignoreAddConnectionPlugin = new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){

                    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
                    }
                };
            }
        };
        broker1.setPlugins(new BrokerPlugin[]{ignoreAddConnectionPlugin});
        this.startAllBrokers();
        final CountDownLatch attemptLatch = new CountDownLatch(2);
        final CountDownLatch createLatch = new CountDownLatch(2);
        DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(){

            public void onServiceAdd(DiscoveryEvent event) {
                attemptLatch.countDown();
                super.onServiceAdd(event);
            }

            protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, DiscoveryEvent event) {
                try {
                    attemptLatch.await();
                    createLatch.countDown();
                    createLatch.await(ATTEMPT_TO_CREATE_DELAY, TimeUnit.MILLISECONDS);
                    return super.createBridge(localTransport, remoteTransport, event);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return null;
                }
            }
        };
        nc.setDiscoveryAgent(new DiscoveryAgent(){
            TaskRunnerFactory taskRunner = new TaskRunnerFactory();
            DiscoveryListener listener;

            public void start() throws Exception {
                this.taskRunner.init();
                this.taskRunner.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onServiceAdd(new DiscoveryEvent(broker2.getVmConnectorURI().toString()));
                    }
                });
                this.taskRunner.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onServiceAdd(new DiscoveryEvent(broker2.getVmConnectorURI().toString()));
                    }
                });
            }

            public void stop() throws Exception {
                this.taskRunner.shutdown();
            }

            public void setDiscoveryListener(DiscoveryListener listener) {
                this.listener = listener;
            }

            public void registerService(String name) throws IOException {
            }

            public void serviceFailed(DiscoveryEvent event) throws IOException {
                this.listener.onServiceRemove(event);
            }
        });
        broker1.addNetworkConnector((NetworkConnector)nc);
        nc.start();
        this.waitForBridge(broker1.getBrokerName(), broker2.getBrokerName(), this.MAX_TEST_TIME, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)nc.activeBridges().isEmpty());
    }

    public void testInactiveBridgStillActive() throws Exception {
        BrokerService broker1 = this.createBroker(new URI("broker:(vm://broker1)/broker1?persistent=false"));
        BrokerService broker2 = this.createBroker(new URI("broker:(vm://broker2)/broker2?persistent=false"));
        BrokerPlugin disallowAddConnectionPlugin = new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){

                    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
                        throw new Exception("Test exception to force bridge failure");
                    }
                };
            }
        };
        broker1.setPlugins(new BrokerPlugin[]{disallowAddConnectionPlugin});
        this.startAllBrokers();
        SimpleDiscoveryAgent da = new SimpleDiscoveryAgent();
        da.setServices(new URI[]{broker2.getVmConnectorURI()});
        final CountDownLatch attemptLatch = new CountDownLatch(3);
        final CountDownLatch removedLatch = new CountDownLatch(1);
        DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(){

            public void onServiceAdd(DiscoveryEvent event) {
                attemptLatch.countDown();
                super.onServiceAdd(event);
            }

            public void onServiceRemove(DiscoveryEvent event) {
                super.onServiceRemove(event);
                removedLatch.countDown();
            }

            protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, DiscoveryEvent event) {
                final NetworkBridge next = super.createBridge(localTransport, remoteTransport, event);
                return new NetworkBridge(){

                    public void start() throws Exception {
                        next.start();
                        removedLatch.await();
                    }

                    public void stop() throws Exception {
                        next.stop();
                    }

                    public void serviceRemoteException(Throwable error) {
                        next.serviceRemoteException(error);
                    }

                    public void serviceLocalException(Throwable error) {
                        next.serviceLocalException(error);
                    }

                    public void setNetworkBridgeListener(NetworkBridgeListener listener) {
                        next.setNetworkBridgeListener(listener);
                    }

                    public String getRemoteAddress() {
                        return next.getRemoteAddress();
                    }

                    public String getRemoteBrokerName() {
                        return next.getRemoteBrokerName();
                    }

                    public String getRemoteBrokerId() {
                        return next.getRemoteBrokerId();
                    }

                    public String getLocalAddress() {
                        return next.getLocalAddress();
                    }

                    public String getLocalBrokerName() {
                        return next.getLocalBrokerName();
                    }

                    public long getEnqueueCounter() {
                        return next.getEnqueueCounter();
                    }

                    public long getDequeueCounter() {
                        return next.getDequeueCounter();
                    }

                    public NetworkBridgeStatistics getNetworkBridgeStatistics() {
                        return next.getNetworkBridgeStatistics();
                    }

                    public void setMbeanObjectName(ObjectName objectName) {
                        next.setMbeanObjectName(objectName);
                    }

                    public ObjectName getMbeanObjectName() {
                        return next.getMbeanObjectName();
                    }

                    public void resetStats() {
                        next.resetStats();
                    }
                };
            }
        };
        nc.setDiscoveryAgent((DiscoveryAgent)da);
        broker1.addNetworkConnector((NetworkConnector)nc);
        nc.start();
        Assert.assertTrue((boolean)attemptLatch.await(30L, TimeUnit.SECONDS));
    }

    public void testAllowAttemptsAfterRestart() throws Exception {
        long STOP_DELAY = TimeUnit.SECONDS.toMillis(10L);
        BrokerService broker1 = this.createBroker(new URI("broker:(vm://broker1)/broker1?persistent=false"));
        BrokerService broker2 = this.createBroker(new URI("broker:(vm://broker2)/broker2?persistent=false"));
        this.startAllBrokers();
        NetworkConnector nc = this.bridgeBrokers(broker1.getBrokerName(), broker2.getBrokerName());
        nc.start();
        this.waitForBridge(broker1.getBrokerName(), broker2.getBrokerName(), this.MAX_TEST_TIME, TimeUnit.MILLISECONDS);
        nc.stop();
        Thread.sleep(STOP_DELAY);
        nc.start();
        this.waitForBridge(broker1.getBrokerName(), broker2.getBrokerName(), this.MAX_TEST_TIME, TimeUnit.MILLISECONDS);
    }
}

