/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.util.LoggingBrokerPlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3779Test {
    private static final Logger LOG = (Logger)Logger.class.cast(LogManager.getLogger(AMQ3779Test.class));
    private static final String qName = "QNameToFind";
    private BrokerService brokerService;
    private Appender appender;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private final AtomicBoolean gotZeroSize = new AtomicBoolean(false);

    @Before
    public void setUp() throws Exception {
        this.ok.set(false);
        Logger rootLogger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        this.appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                String msg;
                if (event.getLoggerName().toString().contains(AMQ3779Test.qName)) {
                    AMQ3779Test.this.ok.set(true);
                }
                if ((msg = event.getMessage().getFormattedMessage()).contains("Sending") && msg.contains("size = 0")) {
                    AMQ3779Test.this.gotZeroSize.set(true);
                }
            }
        };
        this.appender.start();
        LOG.get().addAppender(this.appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        LOG.addAppender(this.appender);
        LOG.setLevel(Level.TRACE);
        rootLogger.get().addAppender(this.appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        rootLogger.addAppender(this.appender);
        try {
            this.brokerService = new BrokerService();
            LoggingBrokerPlugin loggingBrokerPlugin = new LoggingBrokerPlugin();
            loggingBrokerPlugin.setPerDestinationLogger(true);
            loggingBrokerPlugin.setLogAll(true);
            this.brokerService.setPlugins((BrokerPlugin[])new LoggingBrokerPlugin[]{loggingBrokerPlugin});
            this.brokerService.setPersistent(false);
            this.brokerService.setUseJmx(false);
            this.brokerService.start();
        }
        finally {
            LOG.removeAppender(this.appender);
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.brokerService != null) {
                this.brokerService.stop();
                this.brokerService.waitUntilStopped();
            }
        }
        finally {
            ((Logger)Logger.class.cast(LogManager.getRootLogger())).removeAppender(this.appender);
        }
    }

    @Test(timeout=60000L)
    public void testLogPerDest() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.brokerService.getVmConnectorURI()).createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer messageProducer = session.createProducer((Destination)session.createQueue(qName));
        messageProducer.setDeliveryMode(2);
        connection.start();
        messageProducer.send((Message)session.createTextMessage("Hi"));
        connection.close();
        Assert.assertTrue((String)"got expected log message", (boolean)this.ok.get());
        Assert.assertFalse((String)"did not get zero size in send message", (boolean)this.gotZeroSize.get());
    }
}

