/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3674Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ3674Test.class);
    private static final int deliveryMode = 1;
    private static final ActiveMQTopic destination = new ActiveMQTopic("XYZ");
    private ActiveMQConnectionFactory factory;
    private BrokerService broker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeSubscription() throws Exception {
        Connection producerConnection = this.factory.createConnection();
        producerConnection.start();
        Connection consumerConnection = this.factory.createConnection();
        consumerConnection.setClientID("subscriber1");
        Session consumerMQSession = consumerConnection.createSession(false, 2);
        TopicSubscriber activeConsumer = consumerMQSession.createDurableSubscriber((Topic)destination, "myTopic");
        consumerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(1);
        final BrokerView brokerView = this.broker.getAdminView();
        Assert.assertEquals((long)1L, (long)brokerView.getDurableTopicSubscribers().length);
        LOG.info("Current Durable Topic Subscriptions: " + brokerView.getDurableTopicSubscribers().length);
        try {
            brokerView.destroyDurableSubscriber("subscriber1", "myTopic");
            Assert.fail((String)"Expected Exception for Durable consumer is in use");
        }
        catch (Exception e) {
            LOG.info("Recieved expected exception: " + e.getMessage());
        }
        LOG.info("Current Durable Topic Subscriptions: " + brokerView.getDurableTopicSubscribers().length);
        Assert.assertEquals((long)1L, (long)brokerView.getDurableTopicSubscribers().length);
        activeConsumer.close();
        consumerConnection.stop();
        Assert.assertTrue((String)"The subscription should be in the inactive state.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerView.getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        try {
            brokerView.destroyDurableSubscriber("subscriber1", "myTopic");
        }
        finally {
            producer.close();
            producerConnection.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        TransportConnector connector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(connector.getPublishableConnectString());
        this.factory.setAlwaysSyncSend(true);
        this.factory.setDispatchAsync(false);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }
}

