/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.bugs.AMQ2580Test;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2902Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2580Test.class);
    final AtomicBoolean gotExceptionInLog = new AtomicBoolean(Boolean.FALSE);
    final AtomicBoolean failedToFindMDC = new AtomicBoolean(Boolean.FALSE);
    Appender appender = new DefaultTestAppender(){

        public void append(LogEvent event) {
            if (event.getThrown() != null && event.getThrown() instanceof TransportDisposedIOException) {
                if (AMQ2902Test.this.gotExceptionInLog.get()) {
                    return;
                }
                AMQ2902Test.this.gotExceptionInLog.set(Boolean.TRUE);
                LOG.error("got event: " + event + ", ex:" + event.getThrown(), (Object)event);
                LOG.error("Event source: ", new Throwable("Here"));
            }
            if (!event.getMessage().getFormattedMessage().startsWith("Loaded the Bouncy Castle security provider at position") && event.getContextData().getValue("activemq.broker") == null) {
                AMQ2902Test.this.failedToFindMDC.set(Boolean.TRUE);
            }
        }
    };

    public void testNoExceptionOnClosewithStartStop() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        connection.stop();
        connection.close();
    }

    public void testNoExceptionOnClose() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        Connection connection = connectionFactory.createConnection();
        connection.close();
    }

    public void setUp() throws Exception {
        this.gotExceptionInLog.set(Boolean.FALSE);
        this.failedToFindMDC.set(Boolean.FALSE);
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addAppender(this.appender);
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)(TransportConnection.class.getName() + ".Transport"))).setLevel(Level.DEBUG);
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger(TransportConnection.class)).setLevel(Level.DEBUG);
    }

    public void tearDown() throws Exception {
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).removeAppender(this.appender);
        AMQ2902Test.assertFalse((String)"got unexpected ex in log on graceful close", (boolean)this.gotExceptionInLog.get());
        AMQ2902Test.assertFalse((String)"MDC is there", (boolean)this.failedToFindMDC.get());
    }
}

