/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTopicWildcardTest {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopicWildcardTest.class);
    protected int total = 3;
    protected Connection connection;
    BrokerService brokerService;

    @Before
    public void init() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.connection = this.createConnection();
        this.connection.start();
    }

    @After
    public void afer() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.brokerService.stop();
    }

    @Test
    public void testWildcardAndSimpleConsumerShareMessages() throws Exception {
        ConsumerBean messageList1 = new ConsumerBean("1:");
        ConsumerBean messageList2 = new ConsumerBean("2:");
        ConsumerBean messageList3 = new ConsumerBean("3:");
        messageList1.setVerbose(true);
        messageList2.setVerbose(true);
        messageList3.setVerbose(true);
        Session session = this.connection.createSession(false, 1);
        ActiveMQTopic producerDestination = new ActiveMQTopic("VirtualTopic.TEST.A.IT");
        ActiveMQQueue destination1 = new ActiveMQQueue("Consumer.1.VirtualTopic.TEST.>");
        ActiveMQQueue destination2 = new ActiveMQQueue("Consumer.1.VirtualTopic.TEST.A.IT");
        ActiveMQQueue destination3 = new ActiveMQQueue("Consumer.1.VirtualTopic.TEST.B.IT");
        LOG.info("Sending to: " + (Destination)producerDestination);
        LOG.info("Consuming from: " + (Destination)destination1 + " and " + (Destination)destination2 + ", and " + (Destination)destination3);
        MessageConsumer c1 = session.createConsumer((Destination)destination1, null);
        MessageConsumer c2 = session.createConsumer((Destination)destination2, null);
        MessageConsumer c3 = session.createConsumer((Destination)destination3, null);
        c1.setMessageListener((MessageListener)messageList1);
        c2.setMessageListener((MessageListener)messageList2);
        c3.setMessageListener((MessageListener)messageList3);
        MessageProducer producer = session.createProducer((Destination)producerDestination);
        TestCase.assertNotNull((Object)producer);
        for (int i = 0; i < this.total; ++i) {
            producer.send(this.createMessage(session, i));
        }
        this.assertMessagesArrived(messageList1, messageList2);
        TestCase.assertEquals((int)0, (int)messageList3.getMessages().size());
    }

    private Message createMessage(Session session, int i) throws JMSException {
        return session.createTextMessage("val=" + i);
    }

    private Connection createConnection() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.brokerService.getVmConnectorURI());
        cf.setWatchTopicAdvisories(false);
        return cf.createConnection();
    }

    protected void assertMessagesArrived(final ConsumerBean messageList1, final ConsumerBean messageList2) {
        try {
            Assert.assertTrue((String)"expected", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    LOG.info("One: " + messageList1.getMessages().size() + ", Two:" + messageList2.getMessages().size());
                    return messageList1.getMessages().size() + messageList2.getMessages().size() == 2 * VirtualTopicWildcardTest.this.total;
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setAdvisorySupport(false);
        broker.setPersistent(false);
        VirtualTopic virtualTopic = new VirtualTopic();
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{virtualTopic});
        broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        return broker;
    }
}

