/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.MessageDispatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AdvisoryTests {
    protected static final int MESSAGE_COUNT = 100;
    protected BrokerService broker;
    protected Connection connection;
    protected String bindAddress = ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL;
    protected final boolean includeBodyForAdvisory;
    protected final boolean persistent;
    protected final int EXPIRE_MESSAGE_PERIOD = 3000;
    protected final int DEFAULT_PREFETCH = 50;

    @Parameterized.Parameters(name="includeBodyForAdvisory={0}, persistent={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, false}, {false, false}, {true, true}, {false, true});
    }

    public AdvisoryTests(boolean includeBodyForAdvisory, boolean persistent) {
        this.includeBodyForAdvisory = includeBodyForAdvisory;
        this.persistent = persistent;
    }

    @Test(timeout=60000L)
    public void testNoSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testQueueSlowConsumerAdvisory() throws Exception {
        this.testSlowConsumerAdvisory((Destination)new ActiveMQQueue(this.getClass().getName()));
    }

    @Test(timeout=60000L)
    public void testTopicSlowConsumerAdvisory() throws Exception {
        this.broker.getDestinationPolicy().getDefaultEntry().setTopicPrefetch(10);
        this.broker.getDestinationPolicy().getDefaultEntry().setPendingMessageLimitStrategy(null);
        this.testSlowConsumerAdvisory((Destination)new ActiveMQTopic(this.getClass().getName()));
    }

    @Test(timeout=60000L)
    public void testDurableSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Topic topic = s.createTopic(this.getClass().getName());
        TopicSubscriber consumer = s.createDurableSubscriber(topic, "sub1");
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)topic));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)topic);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    private void testSlowConsumerAdvisory(Destination dest) throws Exception {
        Session s = this.connection.createSession(false, 1);
        MessageConsumer consumer = s.createConsumer(dest);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)dest));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer(dest);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testQueueMessageDeliveryAdvisory() throws Exception {
        this.testMessageConsumerAdvisory((ActiveMQDestination)new ActiveMQQueue(this.getClass().getName()), AdvisorySupport::getMessageDeliveredAdvisoryTopic, false);
    }

    @Test(timeout=60000L)
    public void testQueueMessageDeliveryAdvisoryTransacted() throws Exception {
        this.testMessageConsumerAdvisory((ActiveMQDestination)new ActiveMQQueue(this.getClass().getName()), AdvisorySupport::getMessageDeliveredAdvisoryTopic, true);
    }

    @Test(timeout=60000L)
    public void testTopicMessageDeliveryAdvisory() throws Exception {
        this.testMessageConsumerAdvisory((ActiveMQDestination)new ActiveMQTopic(this.getClass().getName()), AdvisorySupport::getMessageDeliveredAdvisoryTopic, false);
    }

    @Test(timeout=60000L)
    public void testTopicMessageDeliveryAdvisoryTransacted() throws Exception {
        this.testMessageConsumerAdvisory((ActiveMQDestination)new ActiveMQTopic(this.getClass().getName()), AdvisorySupport::getMessageDeliveredAdvisoryTopic, true);
    }

    private void testMessageConsumerAdvisory(ActiveMQDestination dest, Function<ActiveMQDestination, Topic> advisoryTopicSupplier, boolean transacted) throws Exception {
        Session s = this.connection.createSession(transacted, 1);
        MessageConsumer consumer = s.createConsumer((Destination)dest);
        Assert.assertNotNull((Object)consumer);
        Topic advisoryTopic = advisoryTopicSupplier.apply(dest);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)dest);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        if (transacted) {
            s.commit();
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        if (transacted) {
            s.commit();
        }
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        String originBrokerUrl = (String)message.getProperty("originBrokerURL");
        Assert.assertTrue((originBrokerUrl.startsWith("tcp://") || originBrokerUrl.startsWith("nio://") ? 1 : 0) != 0);
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)dest.getQualifiedName());
        this.assertIncludeBodyForAdvisory(payload);
    }

    private void testDurableSubscriptionAdvisory(Function<ActiveMQDestination, Topic> advisoryTopicSupplier, boolean transacted) throws Exception {
        Session s = this.connection.createSession(transacted, 1);
        Topic topic = s.createTopic(this.getClass().getName());
        TopicSubscriber consumer = s.createDurableSubscriber(topic, "sub");
        Assert.assertNotNull((Object)consumer);
        Topic advisoryTopic = advisoryTopicSupplier.apply((ActiveMQDestination)topic);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)topic);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        if (transacted) {
            s.commit();
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        if (transacted) {
            s.commit();
        }
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertTrue((boolean)((String)message.getProperty("originBrokerURL")).startsWith("tcp://"));
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)topic).getQualifiedName());
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageConsumedAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageConsumedAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        String id = m.getJMSMessageID();
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        String originalId = payload.getJMSMessageID();
        Assert.assertEquals((Object)originalId, (Object)id);
        Assert.assertTrue((boolean)((String)message.getProperty("originBrokerURL")).startsWith("tcp://"));
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)queue).getQualifiedName());
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryQueueSubClient() throws Exception {
        this.testMessageExpiredAdvisoryQueue(new ActiveMQQueue(this.getClass().getName() + "client.timeout"), 300000, true, 500);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryQueueSubServer() throws Exception {
        this.testMessageExpiredAdvisoryQueue(new ActiveMQQueue(this.getClass().getName()), 1, true, 500);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryQueueSubServerTask() throws Exception {
        this.testMessageExpiredAdvisoryQueue(new ActiveMQQueue(this.getClass().getName()), 1000, false, 6000);
    }

    private void testMessageExpiredAdvisoryQueue(ActiveMQQueue dest, int ttl, boolean createConsumer, int receiveTimeout) throws Exception {
        Session s = this.connection.createSession(false, 1);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getExpiredMessageTopic((ActiveMQDestination)dest);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)dest);
        producer.setTimeToLive((long)ttl);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        MessageConsumer consumer = null;
        if (createConsumer) {
            consumer = s.createConsumer((Destination)dest);
            Assert.assertNotNull((Object)consumer);
        }
        Message msg = advisoryConsumer.receive((long)receiveTimeout);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertNotNull((Object)message.getProperty("originBrokerURL"));
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryTopicSub() throws Exception {
        int i;
        ActiveMQTopic dest = new ActiveMQTopic(this.getClass().getName());
        this.broker.getDestinationPolicy().getDefaultEntry().setTopicPrefetch(1);
        Session s = this.connection.createSession(false, 1);
        MessageConsumer consumer = s.createConsumer((Destination)dest);
        MessageConsumer expiredAdvisoryConsumer = s.createConsumer((Destination)AdvisorySupport.getExpiredMessageTopic((ActiveMQDestination)dest));
        MessageConsumer discardedAdvisoryConsumer = s.createConsumer((Destination)AdvisorySupport.getMessageDiscardedAdvisoryTopic((ActiveMQDestination)dest));
        MessageProducer producer = s.createProducer((Destination)dest);
        producer.setTimeToLive(10L);
        for (i = 0; i < 10; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Thread.sleep(500L);
        for (i = 0; i < 10; ++i) {
            Assert.assertNull((Object)consumer.receive(10L));
        }
        Assert.assertNull((Object)discardedAdvisoryConsumer.receive(1000L));
        Message msg = expiredAdvisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertNotNull((Object)message.getProperty("originBrokerURL"));
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryDurableClient() throws Exception {
        this.testMessageExpiredDurableAdvisory(this.getClass().getName() + "client.timeout", 300000, true, 500);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryDurableServer() throws Exception {
        this.testMessageExpiredDurableAdvisory(this.getClass().getName(), 1, true, 500);
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisoryDurableServerTask() throws Exception {
        this.testMessageExpiredDurableAdvisory(this.getClass().getName(), 2000, false, 6000);
    }

    private void testMessageExpiredDurableAdvisory(String topic, int ttl, boolean bringDurableOnline, int receiveTimeout) throws Exception {
        ActiveMQTopic dest = new ActiveMQTopic(topic);
        Session s = this.connection.createSession(false, 1);
        TopicSubscriber consumer = s.createDurableSubscriber((Topic)dest, "sub1");
        consumer.close();
        ActiveMQTopic advisoryTopic = AdvisorySupport.getExpiredMessageTopic((ActiveMQDestination)dest);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)dest);
        producer.setTimeToLive((long)ttl);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        if (bringDurableOnline) {
            consumer = s.createDurableSubscriber((Topic)dest, "sub1");
        }
        Message msg = advisoryConsumer.receive((long)receiveTimeout);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertNotNull((Object)message.getProperty("originBrokerURL"));
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageDLQd() throws Exception {
        ActiveMQPrefetchPolicy policy = new ActiveMQPrefetchPolicy();
        policy.setTopicPrefetch(2);
        ((ActiveMQConnection)this.connection).setPrefetchPolicy(policy);
        Session s = this.connection.createSession(false, 2);
        Topic topic = s.createTopic(this.getClass().getName());
        Topic advisoryTopic = s.createTopic(">");
        for (int i = 0; i < 100; ++i) {
            s.createConsumer((Destination)advisoryTopic);
        }
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)AdvisorySupport.getMessageDLQdAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)topic)));
        MessageProducer producer = s.createProducer((Destination)topic);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertNotNull((Object)message.getProperty("originBrokerURL"));
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageDiscardedAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 2);
        Topic topic = s.createTopic(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)topic);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageDiscardedAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)topic));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)topic);
        for (int i = 0; i < 100; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        Assert.assertNotNull((Object)message.getProperty("originBrokerURL"));
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)topic).getQualifiedName());
        this.assertIncludeBodyForAdvisory(payload);
    }

    @Test(timeout=60000L)
    public void testMessageDeliveryVTAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        ActiveMQTopic vt = new ActiveMQTopic("VirtualTopic.TEST");
        ActiveMQQueue a = new ActiveMQQueue("Consumer.A.VirtualTopic.TEST");
        MessageConsumer consumer = s.createConsumer((Destination)a);
        ActiveMQQueue b = new ActiveMQQueue("Consumer.B.VirtualTopic.TEST");
        MessageConsumer consumerB = s.createConsumer((Destination)b);
        Assert.assertNotNull((Object)consumer);
        Assert.assertNotNull((Object)consumerB);
        HashSet<String> dests = new HashSet<String>();
        dests.add(vt.getQualifiedName());
        dests.add(a.getQualifiedName());
        dests.add(b.getQualifiedName());
        ActiveMQTopic advisoryTopic = new ActiveMQTopic("ActiveMQ.Advisory.MessageDelivered.>");
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)vt);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        Message msg = null;
        while ((msg = advisoryConsumer.receive(1000L)) != null) {
            ActiveMQMessage message = (ActiveMQMessage)msg;
            String dest = (String)message.getProperty("orignalDestination");
            dests.remove(dest);
            this.assertIncludeBodyForAdvisory((ActiveMQMessage)message.getDataStructure());
        }
        Assert.assertTrue((String)("Got delivered for all: " + dests), (boolean)dests.isEmpty());
    }

    @Before
    public void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.connection = factory.createConnection();
        this.connection.setClientID("clientId");
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.broker.getTransportConnectorByName("OpenWire").getPublishableConnectString());
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(this.persistent);
        answer.setDeleteAllMessagesOnStartup(true);
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(3000L);
        policy.setAdvisoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setIncludeBodyForAdvisory(this.includeBodyForAdvisory);
        policy.setProducerFlowControl(false);
        policy.setDurableTopicPrefetch(50);
        policy.setTopicPrefetch(50);
        policy.setQueuePrefetch(50);
        ConstantPendingMessageLimitStrategy strategy = new ConstantPendingMessageLimitStrategy();
        strategy.setLimit(10);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        answer.setDestinationPolicy(pMap);
        answer.addConnector("nio://localhost:0");
        answer.addConnector("tcp://localhost:0").setName("OpenWire");
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setPlugins(new BrokerPlugin[]{new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){

                    public void preProcessDispatch(MessageDispatch messageDispatch) {
                        ActiveMQDestination dest = messageDispatch.getDestination();
                        if (dest != null && !AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)dest) && messageDispatch.getDestination().getPhysicalName().contains("client.timeout")) {
                            messageDispatch.getMessage().setExpiration(System.currentTimeMillis() - 1000L);
                        }
                        super.preProcessDispatch(messageDispatch);
                    }
                };
            }
        }});
    }

    protected void assertIncludeBodyForAdvisory(ActiveMQMessage payload) {
        if (this.includeBodyForAdvisory) {
            Assert.assertNotNull((Object)payload.getContent());
        } else {
            Assert.assertNull((Object)payload.getContent());
        }
    }
}

