/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BrowseDLQTest {
    private static final int NUM_MESSAGES = 100;
    private BrokerService brokerService;
    private ActiveMQQueue testQueue = new ActiveMQQueue("TEST.FOO");
    private ActiveMQQueue dlq = new ActiveMQQueue("ActiveMQ.DLQ");

    @Test
    public void testCannotBrowseDLQAsTable() throws Exception {
        this.startBroker();
        this.sendMessagesToBeExpired();
        TimeUnit.SECONDS.sleep(2L);
        this.assertCanBrowse();
    }

    private void assertCanBrowse() throws MalformedObjectNameException, OpenDataException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=ActiveMQ.DLQ");
        QueueViewMBean queue = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        Assert.assertTrue((queue.getQueueSize() > 0L ? 1 : 0) != 0);
        CompositeData[] regularBrowse = queue.browse();
        Assert.assertNotNull((Object)regularBrowse);
        TabularData tableData = queue.browseAsTable();
        Assert.assertNotNull((Object)tableData);
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    private void startBroker() throws Exception {
        this.brokerService = BrokerFactory.createBroker((String)"broker:()/localhost?deleteAllMessagesOnStartup=true");
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setExpireMessagesPeriod(1000L);
        policyMap.setDefaultEntry(policyEntry);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    private void sendMessagesToBeExpired() throws JMSException, InterruptedException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.testQueue);
        for (int i = 0; i < 100; ++i) {
            producer.send((Destination)this.testQueue, (Message)session.createTextMessage("Hello world #" + i), 2, 4, 500L);
        }
        connection.close();
    }
}

