/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterTestSupport;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class KahaDBPersistenceAdapterTest
extends PersistenceAdapterTestSupport {
    protected PersistenceAdapter createPersistenceAdapter(boolean delete) throws IOException {
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoReplayOnStop() throws Exception {
        this.brokerService.getPersistenceAdapter().checkpoint(true);
        this.brokerService.stop();
        final AtomicBoolean gotSomeReplay = new AtomicBoolean(Boolean.FALSE);
        final AtomicBoolean trappedLogMessages = new AtomicBoolean(Boolean.FALSE);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                trappedLogMessages.set(true);
                if (event.getLevel().equals((Object)Level.INFO) && event.getMessage().toString().contains("Recovery replayed ")) {
                    gotSomeReplay.set(true);
                }
            }
        };
        try {
            Logger.getLogger((String)MessageDatabase.class.getName()).addAppender((Appender)appender);
            Logger.getLogger((String)MessageDatabase.class.getName()).setLevel(Level.INFO);
            this.brokerService = new BrokerService();
            this.pa = this.createPersistenceAdapter(false);
            this.brokerService.setPersistenceAdapter(this.pa);
            this.brokerService.start();
        }
        finally {
            Logger.getRootLogger().removeAppender((Appender)appender);
            Logger.getLogger((String)MessageDatabase.class.getName()).removeAppender((Appender)appender);
        }
        KahaDBPersistenceAdapterTest.assertTrue((String)"log capture working", (boolean)trappedLogMessages.get());
        KahaDBPersistenceAdapterTest.assertFalse((String)"no replay message in the log", (boolean)gotSomeReplay.get());
    }
}

