/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.store.AbstractMessageStoreSizeStatTest;
import org.apache.commons.io.FileUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBMessageStoreSizeStatTest
extends AbstractMessageStoreSizeStatTest {
    protected static final Logger LOG = LoggerFactory.getLogger(KahaDBMessageStoreSizeStatTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));

    @Override
    protected void setUpBroker(boolean clearDataDir) throws Exception {
        if (clearDataDir && this.dataFileDir.getRoot().exists()) {
            FileUtils.cleanDirectory((File)this.dataFileDir.getRoot());
        }
        super.setUpBroker(clearDataDir);
    }

    @Override
    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.broker.setPersistent(true);
        this.broker.setDataDirectoryFile(this.dataFileDir.getRoot());
    }

    @Test(timeout=60000L)
    public void testMessageSizeAfterRestartAndPublish() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Destination dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 200, publishedMessageSize.get());
        this.stopBroker();
        this.setUpBroker(false);
        dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 400, publishedMessageSize.get());
    }
}

