/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.ActiveMQSslConnectionFactoryTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkReconnectSslNioTest {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkReconnectSslNioTest.class);

    @Test
    public void testForceReconnect() throws Exception {
        SslContext sslContext = new SslContext(ActiveMQSslConnectionFactoryTest.getKeyManager(), ActiveMQSslConnectionFactoryTest.getTrustManager(), null);
        BrokerService remote = new BrokerService();
        remote.setBrokerName("R");
        remote.setSslContext(sslContext);
        remote.setUseJmx(false);
        remote.setPersistent(false);
        TransportConnector transportConnector = remote.addConnector("nio+ssl://0.0.0.0:0");
        remote.start();
        BrokerService local = new BrokerService();
        local.setSslContext(sslContext);
        local.setUseJmx(false);
        local.setPersistent(false);
        final NetworkConnector networkConnector = local.addNetworkConnector("static:(" + remote.getTransportConnectorByScheme("nio+ssl").getPublishableConnectString().replace("nio+ssl", "ssl") + "?socket.verifyHostName=false)?useExponentialBackOff=false&initialReconnectDelay=10");
        local.start();
        Assert.assertTrue((String)"Bridge created", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !networkConnector.activeBridges().isEmpty() && networkConnector.activeBridges().toArray(new DurableConduitBridge[0])[0].getRemoteBrokerName() != null;
            }
        }));
        final AtomicReference<DurableConduitBridge> bridge = new AtomicReference<DurableConduitBridge>((DurableConduitBridge)networkConnector.activeBridges().iterator().next());
        Assert.assertTrue((String)"Connected to R", (boolean)bridge.get().getRemoteBrokerName().equals("R"));
        for (int i = 0; i < 200; ++i) {
            LOG.info("Forcing error on NC via remote exception, iteration:" + i + ",  bridge: " + bridge);
            TransportConnection connection = (TransportConnection)transportConnector.getConnections().iterator().next();
            connection.dispatchAsync((Command)new ConnectionError());
            Assert.assertTrue((String)"bridge failed", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return ((DurableConduitBridge)bridge.get()).bridgeFailed.get();
                }
            }, (long)10000L, (long)10L));
            bridge.set(null);
            Assert.assertTrue((String)("Bridge recreated: " + i), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    if (!networkConnector.activeBridges().isEmpty()) {
                        try {
                            DurableConduitBridge durableConduitBridge = (DurableConduitBridge)networkConnector.activeBridges().iterator().next();
                            if ("R".equals(durableConduitBridge.getRemoteBrokerName())) {
                                bridge.set(durableConduitBridge);
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    return bridge.get() != null;
                }
            }, (long)10000L, (long)10L));
        }
        local.stop();
        remote.stop();
    }
}

