/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.ConditionalNetworkBridgeFilterFactory;
import org.apache.activemq.network.NetworkBridgeFilterFactory;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class DrainBridgeTest {
    @Test
    public void testDrain() throws Exception {
        this.prepareBrokerWithMessages();
        final BrokerService target = this.prepareDrainTarget();
        final BrokerService drainingBroker = new BrokerService();
        drainingBroker.setBrokerName("HOST");
        NetworkConnector drainingNetworkConnector = drainingBroker.addNetworkConnector("static:(" + target.getTransportConnectorByScheme("tcp").getPublishableConnectString() + ")");
        drainingNetworkConnector.setStaticBridge(true);
        drainingNetworkConnector.setStaticallyIncludedDestinations(Arrays.asList(new ActiveMQQueue(">")));
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(0L);
        ConditionalNetworkBridgeFilterFactory filterFactory = new ConditionalNetworkBridgeFilterFactory();
        filterFactory.setReplayWhenNoConsumers(true);
        defaultEntry.setNetworkBridgeFilterFactory((NetworkBridgeFilterFactory)filterFactory);
        policyMap.setDefaultEntry(defaultEntry);
        drainingBroker.setDestinationPolicy(policyMap);
        drainingBroker.start();
        System.out.println("Local count: " + drainingBroker.getAdminView().getTotalMessageCount() + ", target count:" + target.getAdminView().getTotalMessageCount());
        Assert.assertEquals((String)"local messages", (long)22L, (long)drainingBroker.getAdminView().getTotalMessageCount());
        Assert.assertEquals((String)"no remote messages", (long)0L, (long)target.getAdminView().getTotalMessageCount());
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                System.out.println("Local count: " + drainingBroker.getAdminView().getTotalMessageCount() + ", target count:" + target.getAdminView().getTotalMessageCount());
                return drainingBroker.getAdminView().getTotalMessageCount() == 0L;
            }
        });
        Assert.assertEquals((String)"no local messages", (long)0L, (long)drainingBroker.getAdminView().getTotalMessageCount());
        Assert.assertEquals((String)"remote messages", (long)22L, (long)target.getAdminView().getTotalMessageCount());
        Assert.assertEquals((String)"number of queues match", (long)drainingBroker.getAdminView().getQueues().length, (long)target.getAdminView().getQueues().length);
        drainingBroker.stop();
        target.stop();
    }

    private BrokerService prepareDrainTarget() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setBrokerName("TARGET");
        broker.addConnector("tcp://localhost:0");
        broker.start();
        return broker;
    }

    private void prepareBrokerWithMessages() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setBrokerName("HOST");
        broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(broker.getVmConnectorURI());
        Connection conn = connectionFactory.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        TextMessage msg = session.createTextMessage("This is a message.");
        MessageProducer producer = session.createProducer(null);
        ActiveMQQueue queue = new ActiveMQQueue("Q.Foo,Bar");
        for (int i = 0; i < 10; ++i) {
            producer.send((Destination)queue, (Message)msg);
        }
        MessageConsumer messageConsumerA = session.createConsumer((Destination)new ActiveMQQueue("Consumer.A.VirtualTopic.Y"));
        MessageConsumer messageConsumeB = session.createConsumer((Destination)new ActiveMQQueue("Consumer.B.VirtualTopic.Y"));
        producer.send((Destination)new ActiveMQTopic("VirtualTopic.Y"), (Message)msg);
        conn.close();
        broker.stop();
    }
}

