/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkTestSupport;

public class DemandForwardingBridgeSupportTest
extends NetworkTestSupport {
    private DemandForwardingBridge bridge;
    private StubConnection producerConnection;
    private ProducerInfo producerInfo;
    private StubConnection consumerConnection;
    private SessionInfo consumerSessionInfo;

    public void testOverflow() throws Exception {
        NetworkBridgeConfiguration configuration = this.getDefaultBridgeConfiguration();
        configuration.setExcludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"OTHER.>", (byte)2)));
        configuration.setDynamicallyIncludedDestinations(Arrays.asList(ActiveMQDestination.createDestination((String)"TEST", (byte)1)));
        this.configureAndStartBridge(configuration);
        this.assertReceiveMessageOn("TEST", (byte)1);
        this.assertReceiveNoMessageOn("OTHER.T1", (byte)2);
    }

    private void assertReceiveMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeSupportTest.assertNotNull((Object)m);
    }

    private void assertReceiveNoMessageOn(String destinationName, byte destinationType) throws Exception, InterruptedException {
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)destinationType);
        this.producerConnection.send((Command)this.createMessage(this.producerInfo, destination, destinationType));
        Message m = this.createConsumerAndReceiveMessage(destination);
        DemandForwardingBridgeSupportTest.assertNull((Object)m);
    }

    private Message createConsumerAndReceiveMessage(ActiveMQDestination destination) throws Exception {
        ConsumerInfo consumerInfo = this.createConsumerInfo(this.consumerSessionInfo, destination);
        this.consumerConnection.send((Command)consumerInfo);
        Message m = this.receiveMessage(this.consumerConnection);
        return m;
    }

    private void configureAndStartBridge(NetworkBridgeConfiguration configuration) throws Exception {
        this.bridge = new DemandForwardingBridge(configuration, this.createTransport(), this.createRemoteTransport());
        this.bridge.setBrokerService(this.broker);
        this.bridge.setDynamicallyIncludedDestinations(configuration.getDynamicallyIncludedDestinations().toArray(new ActiveMQDestination[configuration.getDynamicallyIncludedDestinations().size()]));
        this.bridge.setExcludedDestinations(configuration.getExcludedDestinations().toArray(new ActiveMQDestination[configuration.getExcludedDestinations().size()]));
        this.bridge.setStaticallyIncludedDestinations(configuration.getStaticallyIncludedDestinations().toArray(new ActiveMQDestination[configuration.getStaticallyIncludedDestinations().size()]));
        this.bridge.start();
    }

    public NetworkBridgeConfiguration getDefaultBridgeConfiguration() {
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName("local");
        config.setDispatchAsync(false);
        return config;
    }

    @Override
    protected String getLocalURI() {
        int port = DemandForwardingBridgeSupportTest.findFreePort();
        return String.format("tcp://localhost:%d?connectionTimeout=2147483647", port);
    }

    @Override
    protected String getRemoteURI() {
        int port = DemandForwardingBridgeSupportTest.findFreePort();
        return String.format("tcp://localhost:%d?connectionTimeout=2147483647", port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = port;
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IllegalStateException("Could not find a free TCP/IP port to start embedded Jetty HTTP Server on");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.producerConnection = this.createConnection();
        ConnectionInfo producerConnectionInfo = this.createConnectionInfo();
        SessionInfo producerSessionInfo = this.createSessionInfo(producerConnectionInfo);
        this.producerInfo = this.createProducerInfo(producerSessionInfo);
        this.producerConnection.send((Command)producerConnectionInfo);
        this.producerConnection.send((Command)producerSessionInfo);
        this.producerConnection.send((Command)this.producerInfo);
        this.consumerConnection = this.createRemoteConnection();
        ConnectionInfo consumerConnectionInfo = this.createConnectionInfo();
        this.consumerSessionInfo = this.createSessionInfo(consumerConnectionInfo);
        this.consumerConnection.send((Command)consumerConnectionInfo);
        this.consumerConnection.send((Command)this.consumerSessionInfo);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return DemandForwardingBridgeSupportTest.suite(DemandForwardingBridgeSupportTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DemandForwardingBridgeSupportTest.suite());
    }
}

