/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.leveldb.LevelDBPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5567Test
extends BrokerRestartTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AMQ5567Test.class);
    private final ActiveMQQueue destination = new ActiveMQQueue("Q");
    private final String DATA_FOLDER = "./target/AMQ5567Test-data";

    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        super.configureBroker(broker);
        broker.setPersistenceAdapter(this.persistenceAdapter);
    }

    @Override
    protected PolicyEntry getDefaultPolicy() {
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(61440L);
        return policy;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        IOHelper.delete((File)new File("./target/AMQ5567Test-data"));
    }

    public void initCombosForTestPreparedTransactionNotDispatched() throws Exception {
        Object[] persistenceAdapters;
        for (PersistenceAdapter persistenceAdapter : persistenceAdapters = new PersistenceAdapter[]{new KahaDBPersistenceAdapter(), new LevelDBPersistenceAdapter(), new JDBCPersistenceAdapter()}) {
            persistenceAdapter.setDirectory(new File("./target/AMQ5567Test-data"));
        }
        this.addCombinationValues("persistenceAdapter", persistenceAdapters);
    }

    public void testPreparedTransactionNotDispatched() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("Q");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        XATransactionId txid = this.createXATransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        Message message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
        message.setPersistent(true);
        message.setTransactionId((TransactionId)txid);
        connection.send((Command)message);
        connection.send((Command)this.createPrepareTransaction(connectionInfo, (TransactionId)txid));
        message = this.createMessage(producerInfo, (ActiveMQDestination)destination);
        message.setPersistent(true);
        connection.send((Command)message);
        StubConnection connectionC = this.createConnection();
        ConnectionInfo connectionInfoC = this.createConnectionInfo();
        SessionInfo sessionInfoC = this.createSessionInfo(connectionInfoC);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfoC, (ActiveMQDestination)destination);
        connectionC.send((Command)connectionInfoC);
        connectionC.send((Command)sessionInfoC);
        connectionC.send((Command)consumerInfo);
        Message m = this.receiveMessage(connectionC, TimeUnit.SECONDS.toMillis(10L));
        LOG.info("received: " + m);
        AMQ5567Test.assertNotNull((String)"Got message", (Object)m);
        AMQ5567Test.assertNull((String)"Got non tx message", (Object)m.getTransactionId());
        AMQ5567Test.assertNull((Object)this.receiveMessage(connectionC));
        this.assertNoMessagesLeft(connectionC);
        LOG.info("commit: " + txid);
        connection.request((Command)this.createCommitTransaction2Phase(connectionInfo, (TransactionId)txid));
        m = this.receiveMessage(connectionC, TimeUnit.SECONDS.toMillis(10L));
        LOG.info("received: " + m);
        AMQ5567Test.assertNotNull((String)"Got non null message", (Object)m);
    }

    public void initCombosForTestCursorStoreSync() throws Exception {
        Object[] persistenceAdapters;
        for (PersistenceAdapter persistenceAdapter : persistenceAdapters = new PersistenceAdapter[]{new KahaDBPersistenceAdapter(), new LevelDBPersistenceAdapter(), new JDBCPersistenceAdapter()}) {
            persistenceAdapter.setDirectory(new File(IOHelper.getDefaultDataDirectory()));
        }
        this.addCombinationValues("persistenceAdapter", persistenceAdapters);
    }

    public void testCursorStoreSync() throws Exception {
        int i;
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        XATransactionId txid = this.createXATransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        Message message = this.createMessage(producerInfo, (ActiveMQDestination)this.destination);
        message.setPersistent(true);
        message.setTransactionId((TransactionId)txid);
        connection.request((Command)message);
        connection.request((Command)this.createPrepareTransaction(connectionInfo, (TransactionId)txid));
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        AMQ5567Test.assertTrue((String)"cache is enabled", (boolean)proxy.isCacheEnabled());
        String payload = new String(new byte[10240]);
        for (int i2 = 0; i2 < 6; ++i2) {
            message = this.createMessage(producerInfo, (ActiveMQDestination)this.destination);
            message.setPersistent(true);
            ((TextMessage)message).setText(payload);
            connection.request((Command)message);
        }
        AMQ5567Test.assertTrue((String)"cache is disabled", (!proxy.isCacheEnabled() ? 1 : 0) != 0);
        StubConnection connectionC = this.createConnection();
        ConnectionInfo connectionInfoC = this.createConnectionInfo();
        SessionInfo sessionInfoC = this.createSessionInfo(connectionInfoC);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfoC, (ActiveMQDestination)this.destination);
        connectionC.send((Command)connectionInfoC);
        connectionC.send((Command)sessionInfoC);
        connectionC.send((Command)consumerInfo);
        Message m = null;
        for (i = 0; i < 3; ++i) {
            m = this.receiveMessage(connectionC, TimeUnit.SECONDS.toMillis(10L));
            LOG.info("received: " + m);
            AMQ5567Test.assertNotNull((String)"Got message", (Object)m);
            AMQ5567Test.assertNull((String)"Got non tx message", (Object)m.getTransactionId());
            connectionC.request((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        }
        LOG.info("commit: " + txid);
        connection.request((Command)this.createCommitTransaction2Phase(connectionInfo, (TransactionId)txid));
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connectionC, TimeUnit.SECONDS.toMillis(10L));
            LOG.info("received[" + i + "] " + m);
            AMQ5567Test.assertNotNull((String)"Got message", (Object)m);
            if (i == 3) {
                AMQ5567Test.assertNotNull((String)"Got  tx message", (Object)m.getTransactionId());
            } else {
                AMQ5567Test.assertNull((String)"Got non tx message", (Object)m.getTransactionId());
            }
            connectionC.request((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        }
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:destinationType=Queue,destinationName=" + this.destination.getQueueName() + ",type=Broker,brokerName=localhost");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    public static Test suite() {
        return AMQ5567Test.suite(AMQ5567Test.class);
    }
}

