/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.usecases.MyObject;
import org.junit.Ignore;

@Ignore
public class AMQ2103Test
extends BrokerTestSupport {
    static PolicyEntry reduceMemoryFootprint = new PolicyEntry();
    public PolicyEntry defaultPolicy = reduceMemoryFootprint;

    @Override
    protected PolicyEntry getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void initCombosForTestVerifyMarshalledStateIsCleared() throws Exception {
        this.addCombinationValues("defaultPolicy", new Object[]{this.defaultPolicy, null});
    }

    public static Test suite() {
        return AMQ2103Test.suite(AMQ2103Test.class);
    }

    public void testVerifyMarshalledStateIsCleared() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.setOptimizedMessageDispatch(true);
        factory.setObjectMessageSerializationDefered(true);
        factory.setCopyMessageOnSend(false);
        Connection connection = factory.createConnection();
        ActiveMQSession session = (ActiveMQSession)connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("testQ");
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)destination);
        MyObject obj = new MyObject("A message");
        ActiveMQObjectMessage m1 = (ActiveMQObjectMessage)session.createObjectMessage();
        m1.setObject((Serializable)obj);
        producer.send((Message)m1);
        ActiveMQTextMessage m2 = new ActiveMQTextMessage();
        m2.setText("Test Message Payload.");
        producer.send((Message)m2);
        ActiveMQMapMessage m3 = new ActiveMQMapMessage();
        m3.setString("text", "my message");
        producer.send((Message)m3);
        Message m = consumer.receive((long)this.maxWait);
        AMQ2103Test.assertNotNull((Object)m);
        AMQ2103Test.assertEquals((String)m1.getMessageId().toString(), (String)m.getJMSMessageID());
        AMQ2103Test.assertTrue((boolean)(m instanceof ActiveMQObjectMessage));
        if (this.getDefaultPolicy() != null) {
            AMQ2103Test.assertNull((String)"object data cleared by reduceMemoryFootprint (and never marshalled as using mem persistence)", (Object)((ActiveMQObjectMessage)m).getObject());
        }
        AMQ2103Test.assertEquals((String)"writeObject called", (int)0, (int)obj.getWriteObjectCalled());
        AMQ2103Test.assertEquals((String)"readObject called", (int)0, (int)obj.getReadObjectCalled());
        AMQ2103Test.assertEquals((String)"readObjectNoData called", (int)0, (int)obj.getReadObjectNoDataCalled());
        m = consumer.receive((long)this.maxWait);
        AMQ2103Test.assertNotNull((Object)m);
        AMQ2103Test.assertEquals((String)m2.getMessageId().toString(), (String)m.getJMSMessageID());
        AMQ2103Test.assertTrue((boolean)(m instanceof ActiveMQTextMessage));
        if (this.getDefaultPolicy() != null) {
            AMQ2103Test.assertNull((String)"text cleared by reduceMemoryFootprint (and never marshalled as using mem persistence)", (Object)((ActiveMQTextMessage)m).getText());
        }
        m = consumer.receive((long)this.maxWait);
        AMQ2103Test.assertNotNull((Object)m);
        AMQ2103Test.assertEquals((String)m3.getMessageId().toString(), (String)m.getJMSMessageID());
        AMQ2103Test.assertTrue((boolean)(m instanceof ActiveMQMapMessage));
        if (this.getDefaultPolicy() != null) {
            AMQ2103Test.assertNull((String)"text cleared by reduceMemoryFootprint (and never marshalled as using mem persistence)", (Object)((ActiveMQMapMessage)m).getStringProperty("text"));
        }
        connection.close();
    }

    static {
        reduceMemoryFootprint.setReduceMemoryFootprint(true);
    }
}

