/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;

public class AMQ1687Test
extends EmbeddedBrokerTestSupport {
    private Connection connection;

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.prefetchPolicy.all=5");
    }

    public void testVirtualTopicCreation() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        String queueAName = this.getVirtualTopicConsumerName();
        String queueBName = this.getVirtualTopicConsumerNameB();
        ActiveMQQueue queue1 = new ActiveMQQueue(queueAName);
        ActiveMQQueue queue2 = new ActiveMQQueue(queueBName);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer c1 = session.createConsumer((Destination)queue1);
        MessageConsumer c2 = session.createConsumer((Destination)queue2);
        c1.setMessageListener((MessageListener)messageList);
        c2.setMessageListener((MessageListener)messageList);
        ActiveMQTopic topic = new ActiveMQTopic(this.getVirtualTopicName());
        MessageProducer producer = session.createProducer((Destination)topic);
        AMQ1687Test.assertNotNull((Object)producer);
        int total = 100;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total * 2);
    }

    protected String getVirtualTopicName() {
        return "VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerName() {
        return "Consumer.A.VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerNameB() {
        return "Consumer.B.VirtualTopic.TEST";
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

