/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.util.TimeStampingBrokerPlugin;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TimeStampingBrokerPluginTest
extends TestCase {
    BrokerService broker;
    TransportConnector tcpConnector;
    MessageProducer producer;
    MessageConsumer consumer;
    Connection connection;
    Session session;
    Destination destination;
    String queue = "TEST.FOO";
    long expiry = 500L;

    @Before
    public void setUp() throws Exception {
        TimeStampingBrokerPlugin tsbp = new TimeStampingBrokerPlugin();
        tsbp.setZeroExpirationOverride(this.expiry);
        tsbp.setTtlCeiling(this.expiry);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.setPlugins(new BrokerPlugin[]{tsbp});
        this.tcpConnector = this.broker.addConnector("tcp://localhost:0");
        PolicyEntry policy = new PolicyEntry();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setProcessExpired(true);
        strategy.setUseQueueForQueueMessages(true);
        strategy.setQueuePrefix("DLQ.");
        strategy.setProcessNonPersistent(true);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
        this.broker.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.tcpConnector.getConnectUri());
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createQueue(this.queue);
        this.producer = this.session.createProducer(this.destination);
        this.producer.setDeliveryMode(1);
    }

    @After
    public void tearDown() throws Exception {
        this.producer.close();
        this.consumer.close();
        this.session.close();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testExpirationSet() throws Exception {
        Message sentMessage = this.session.createMessage();
        long beforeSend = System.currentTimeMillis();
        this.producer.send(sentMessage);
        this.consumer = this.session.createConsumer(this.destination);
        Message receivedMessage = this.consumer.receive(1000L);
        TimeStampingBrokerPluginTest.assertEquals((String)sentMessage.getJMSMessageID(), (String)receivedMessage.getJMSMessageID());
        TimeStampingBrokerPluginTest.assertTrue((String)("Expiration should be not null" + receivedMessage.getJMSExpiration() + "\n"), (Long.valueOf(receivedMessage.getJMSExpiration()) != null ? 1 : 0) != 0);
        TimeStampingBrokerPluginTest.assertTrue((String)("Before send: " + beforeSend + " Msg ts: " + receivedMessage.getJMSTimestamp() + " Msg Expiry: " + receivedMessage.getJMSExpiration()), (beforeSend <= receivedMessage.getJMSExpiration() && receivedMessage.getJMSExpiration() <= receivedMessage.getJMSTimestamp() + this.expiry ? 1 : 0) != 0);
    }

    @Test
    public void testExpirationCelingSet() throws Exception {
        Message sentMessage = this.session.createMessage();
        long beforeSend = System.currentTimeMillis();
        long sendExpiry = beforeSend + this.expiry * 22L;
        sentMessage.setJMSExpiration(sendExpiry);
        this.producer.send(sentMessage);
        this.consumer = this.session.createConsumer(this.destination);
        Message receivedMessage = this.consumer.receive(1000L);
        TimeStampingBrokerPluginTest.assertEquals((String)sentMessage.getJMSMessageID(), (String)receivedMessage.getJMSMessageID());
        TimeStampingBrokerPluginTest.assertTrue((String)("Expiration should be not null" + receivedMessage.getJMSExpiration() + "\n"), (Long.valueOf(receivedMessage.getJMSExpiration()) != null ? 1 : 0) != 0);
        TimeStampingBrokerPluginTest.assertTrue((String)("Sent expiry: " + sendExpiry + " Recv ts: " + receivedMessage.getJMSTimestamp() + " Recv expiry: " + receivedMessage.getJMSExpiration()), (beforeSend <= receivedMessage.getJMSExpiration() && receivedMessage.getJMSExpiration() <= receivedMessage.getJMSTimestamp() + this.expiry ? 1 : 0) != 0);
    }

    @Test
    public void testExpirationDLQ() throws Exception {
        Message sentMessage = this.session.createMessage();
        long beforeSend = System.currentTimeMillis();
        long sendExpiry = beforeSend + this.expiry;
        sentMessage.setJMSExpiration(sendExpiry);
        this.producer.send(sentMessage);
        this.consumer = this.session.createConsumer(this.destination);
        Thread.sleep(this.expiry + 250L);
        Message receivedMessage = this.consumer.receive(1000L);
        TimeStampingBrokerPluginTest.assertNull((Object)receivedMessage);
        this.consumer.close();
        this.consumer = this.session.createConsumer((Destination)this.session.createQueue("DLQ." + this.queue));
        receivedMessage = this.consumer.receive(1000L);
        TimeStampingBrokerPluginTest.assertEquals((String)sentMessage.getJMSMessageID(), (String)receivedMessage.getJMSMessageID());
        TimeStampingBrokerPluginTest.assertEquals((String)("Expiration should be zero" + receivedMessage.getJMSExpiration() + "\n"), (long)receivedMessage.getJMSExpiration(), (long)0L);
    }
}

