/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler.memory;

import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobListener;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.broker.scheduler.JobSchedulerTest;
import org.apache.activemq.broker.scheduler.memory.InMemoryJobSchedulerStore;
import org.apache.activemq.util.ByteSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobSchedulerTest {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerTest.class);
    private JobSchedulerStore store;
    private JobScheduler scheduler;

    @Test(timeout=60000L)
    public void testAddLongStringByteSequence() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), 1000L);
        }
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test(timeout=60000L)
    public void testAddCronAndByteSequence() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        Calendar current = Calendar.getInstance();
        current.add(12, 1);
        int minutes = current.get(12);
        int hour = current.get(11);
        int day = current.get(7) - 1;
        String cronTab = String.format("%d %d * * %d", minutes, hour, day);
        String str = new String("test1");
        this.scheduler.schedule("id:1", new ByteSequence(str.getBytes()), cronTab, 0L, 0L, 0);
        Assert.assertTrue((boolean)latch.await(70L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test(timeout=60000L)
    public void testAddLongLongIntStringByteSequence() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        long time = 2000L;
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), "", time, 10L, -1);
        }
        Assert.assertTrue((latch.getCount() == 10L ? 1 : 0) != 0);
        latch.await(3000L, TimeUnit.SECONDS);
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    @Ignore
    public void testAddStopThenDeliver() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        long time = 2000L;
        for (int i = 0; i < 10; ++i) {
            String test = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(test.getBytes()), "", time, 1000L, -1);
        }
        File directory = this.store.getDirectory();
        this.tearDown();
        this.setUp();
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        Assert.assertTrue((latch.getCount() == 10L ? 1 : 0) != 0);
        latch.await(3000L, TimeUnit.SECONDS);
        Assert.assertTrue((latch.getCount() == 0L ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testRemoveLong() throws Exception {
        int COUNT = 10;
        long time = 60000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(str.getBytes()), "", time, 1000L, -1);
        }
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)10L);
        long removeTime = this.scheduler.getNextScheduleTime();
        this.scheduler.remove(removeTime);
        if (size != 0) {
            removeTime = this.scheduler.getNextScheduleTime();
            this.scheduler.remove(removeTime);
        }
        size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test(timeout=60000L)
    public void testRemoveString() throws Exception {
        int COUNT = 10;
        String test = "TESTREMOVE";
        long time = 20000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id" + i, new ByteSequence(str.getBytes()), "", time, 1000L, -1);
            if (i != 5) continue;
            this.scheduler.schedule("TESTREMOVE", new ByteSequence("TESTREMOVE".getBytes()), "", time, 1000L, -1);
        }
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)11L);
        this.scheduler.remove("TESTREMOVE");
        size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)10L);
    }

    @Test(timeout=60000L)
    public void testGetExecutionCount() throws Exception {
        String jobId = "Job-1";
        long time = 10000L;
        final CountDownLatch done = new CountDownLatch(10);
        String str = new String("test");
        this.scheduler.schedule("Job-1", new ByteSequence(str.getBytes()), "", time, 1000L, 10);
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)1L);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                LOG.info("Job exectued: {}", (Object)(11L - done.getCount()));
                done.countDown();
            }
        });
        List jobs = this.scheduler.getNextScheduleJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Job job = (Job)jobs.get(0);
        Assert.assertEquals((Object)"Job-1", (Object)job.getJobId());
        Assert.assertEquals((long)0L, (long)job.getExecutionCount());
        Assert.assertTrue((String)"Should have fired ten times.", (boolean)done.await(60L, TimeUnit.SECONDS));
        Assert.assertTrue((job.getExecutionCount() >= 9 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testgetAllJobs() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long time = 20000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", time, (long)(10 + i), -1);
        }
        List list = this.scheduler.getAllJobs();
        Assert.assertEquals((long)list.size(), (long)10L);
        int count = 0;
        for (Job job : list) {
            Assert.assertEquals((Object)job.getJobId(), (Object)("id:" + count));
            ++count;
        }
    }

    @Test(timeout=60000L)
    public void testgetAllJobsInRange() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long start = 10000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", start + (long)(i * 1000), (long)(10000 + i), 0);
        }
        start = System.currentTimeMillis();
        long finish = start + 12000L + 10000L;
        List list = this.scheduler.getAllJobs(start, finish);
        Assert.assertEquals((long)10L, (long)list.size());
        int count = 0;
        for (Job job : list) {
            Assert.assertEquals((Object)job.getJobId(), (Object)("id:" + count));
            ++count;
        }
    }

    @Test(timeout=60000L)
    public void testRemoveAllJobsInRange() throws Exception {
        int COUNT = 10;
        String ID = "id:";
        long start = 10000L;
        for (int i = 0; i < 10; ++i) {
            String str = new String("test" + i);
            this.scheduler.schedule("id:" + i, new ByteSequence(str.getBytes()), "", start + (long)(i * 1000), (long)(10000 + i), 0);
        }
        start = System.currentTimeMillis();
        long finish = start + 12000L + 10000L;
        this.scheduler.removeAllJobs(start, finish);
        Assert.assertTrue((boolean)this.scheduler.getAllJobs().isEmpty());
    }

    @Before
    public void setUp() throws Exception {
        this.store = new InMemoryJobSchedulerStore();
        this.store.start();
        this.scheduler = this.store.getJobScheduler("test");
        this.scheduler.startDispatching();
    }

    @After
    public void tearDown() throws Exception {
        this.scheduler.stopDispatching();
        this.store.stop();
    }
}

