/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.broker.scheduler.JobSchedulerTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class JobSchedulerTxTest
extends JobSchedulerTestSupport {
    @Test
    public void testTxSendWithRollback() throws Exception {
        int COUNT = 10;
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        connection.start();
        long time = 5000L;
        Session producerSession = connection.createSession(true, 0);
        MessageProducer producer = producerSession.createProducer((Destination)this.destination);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage("test msg");
            message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
            producer.send((Message)message);
        }
        producer.close();
        producerSession.rollback();
        Thread.sleep(2000L);
        Assert.assertEquals((long)10L, (long)latch.getCount());
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)10L, (long)latch.getCount());
    }

    @Test
    public void testTxSendWithCommit() throws Exception {
        int COUNT = 10;
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        connection.start();
        long time = 5000L;
        Session producerSession = connection.createSession(true, 0);
        MessageProducer producer = producerSession.createProducer((Destination)this.destination);
        for (int i = 0; i < 10; ++i) {
            TextMessage message = session.createTextMessage("test msg");
            message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
            producer.send((Message)message);
        }
        producer.close();
        producerSession.commit();
        Thread.sleep(2000L);
        Assert.assertEquals((long)10L, (long)latch.getCount());
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }
}

