/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.partition;

import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.partition.PartitionBrokerPlugin;
import org.apache.activemq.partition.dto.Partitioning;

public class SpringPartitionBrokerTest
extends TestCase {
    public void testCreatePartitionBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((String)"xbean:activemq-partition.xml");
        SpringPartitionBrokerTest.assertEquals((int)1, (int)broker.getPlugins().length);
        PartitionBrokerPlugin plugin = (PartitionBrokerPlugin)broker.getPlugins()[0];
        Partitioning config = plugin.getConfig();
        SpringPartitionBrokerTest.assertEquals((int)2, (int)config.getBrokers().size());
        String json = "{\n  \"by_client_id\":{\n    \"client1\":{\"ids\":[\"broker1\"]},\n    \"client2\":{\"ids\":[\"broker1\",\"broker2\"]}\n  },\n  \"brokers\":{\n    \"broker1\":\"tcp://localhost:61616\",\n    \"broker2\":\"tcp://localhost:61616\"\n  }\n}";
        Partitioning expected = (Partitioning)Partitioning.MAPPER.readValue(json, Partitioning.class);
        SpringPartitionBrokerTest.assertEquals((String)expected.toString(), (String)config.toString());
    }
}

