/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.util.ArrayList;
import javax.jms.InvalidDestinationException;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.JaasAuthenticationPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXRemoveDurableSubscriberTest {
    private static final Logger LOG = LoggerFactory.getLogger(JMXRemoveDurableSubscriberTest.class);
    private BrokerService brokerService;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        JaasAuthenticationPlugin jaasAuthenticationPlugin = new JaasAuthenticationPlugin();
        jaasAuthenticationPlugin.setDiscoverLoginConfig(true);
        BrokerPlugin[] brokerPlugins = new BrokerPlugin[2];
        brokerPlugins[0] = jaasAuthenticationPlugin;
        AuthorizationPlugin authorizationPlugin = new AuthorizationPlugin();
        ArrayList<AuthorizationEntry> destinationMapEntries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry authEntry1 = new AuthorizationEntry();
        authEntry1.setRead("manager,viewer,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser, admin");
        authEntry1.setWrite("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry1.setAdmin("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry1.setQueue(">");
        AuthorizationEntry authEntry2 = new AuthorizationEntry();
        authEntry2.setRead("manager,viewer,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser, admin");
        authEntry2.setWrite("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry2.setAdmin("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry2.setTopic(">");
        AuthorizationEntry authEntry3 = new AuthorizationEntry();
        authEntry3.setRead("manager,viewer,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser, admin");
        authEntry3.setWrite("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry3.setAdmin("manager,Operator,Maintainer,Deployer,Auditor,Administrator,SuperUser,admin");
        authEntry3.setTopic("ActiveMQ.Advisory.>");
        destinationMapEntries.add(authEntry1);
        destinationMapEntries.add(authEntry2);
        destinationMapEntries.add(authEntry3);
        DefaultAuthorizationMap authorizationMap = new DefaultAuthorizationMap(destinationMapEntries);
        authorizationPlugin.setMap((AuthorizationMap)authorizationMap);
        brokerPlugins[1] = authorizationPlugin;
        this.brokerService.setPlugins(brokerPlugins);
        this.brokerService.setBrokerName("ActiveMQBroker");
        this.brokerService.setPersistent(false);
        this.brokerService.setUseVirtualTopics(false);
        this.brokerService.setUseJmx(true);
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            try {
                this.brokerService.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test(timeout=60000L)
    public void testCreateDurableSubsciber() throws Exception {
        boolean subscriberAlreadyDeleted;
        block8: {
            boolean destroySubscriberSecurityException;
            String subscriberName;
            String clientId;
            block7: {
                boolean createSubscriberSecurityException;
                block6: {
                    clientId = "10";
                    this.brokerService.getAdminView().addTopic("testTopic");
                    createSubscriberSecurityException = false;
                    subscriberName = "testSubscriber";
                    try {
                        this.brokerService.getAdminView().createDurableSubscriber(clientId, subscriberName, "testTopic", null);
                        LOG.info("Successfully created durable subscriber " + subscriberName + " via AdminView");
                    }
                    catch (SecurityException se1) {
                        if (!se1.getMessage().equals("User is not authenticated.")) break block6;
                        createSubscriberSecurityException = true;
                    }
                }
                Assert.assertFalse((boolean)createSubscriberSecurityException);
                destroySubscriberSecurityException = false;
                try {
                    this.brokerService.getAdminView().destroyDurableSubscriber(clientId, subscriberName);
                    LOG.info("Successfully destroyed durable subscriber " + subscriberName + " via AdminView");
                }
                catch (SecurityException se2) {
                    if (!se2.getMessage().equals("User is not authenticated.")) break block7;
                    destroySubscriberSecurityException = true;
                }
            }
            Assert.assertFalse((boolean)destroySubscriberSecurityException);
            subscriberAlreadyDeleted = false;
            try {
                this.brokerService.getAdminView().destroyDurableSubscriber(clientId, subscriberName);
                LOG.info("Successfully destroyed durable subscriber " + subscriberName + " via AdminView");
            }
            catch (InvalidDestinationException t) {
                if (!t.getMessage().equals("No durable subscription exists for clientID: 10 and subscriptionName: testSubscriber")) break block8;
                subscriberAlreadyDeleted = true;
            }
        }
        Assert.assertTrue((boolean)subscriberAlreadyDeleted);
    }
}

