/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerReceiveWithTimeoutTest {
    private ActiveMQConnection connection;
    private BrokerService broker;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.createBroker();
        this.connection = this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testConsumerReceiveBeforeMessageDispatched() throws JMSException {
        this.connection.start();
        final Session session = this.connection.createSession(false, 1);
        final Queue queue = session.createQueue("test");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.send((Message)session.createTextMessage("Hello"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(60000L);
        Assert.assertNotNull((Object)msg);
        session.close();
    }

    @Test(timeout=20000L)
    public void testConsumerReceivePrefetchZeroRedeliveryZero() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue("test.prefetch.zero");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage textMessage = session.createTextMessage("test Message");
        producer.send((Message)textMessage);
        session.close();
        session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(2000L);
        Assert.assertNotNull((Object)message);
        session.rollback();
        session.close();
        this.connection.close();
        this.connection = this.createConnection();
        this.connection.getPrefetchPolicy().setQueuePrefetch(0);
        this.connection.getRedeliveryPolicy().setMaximumRedeliveries(0);
        this.connection.start();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)queue);
        message = consumer.receive(3000L);
        Assert.assertNull((Object)message);
    }

    private void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }
}

