/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.ConnectionClosedException;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.MutableBrokerFilter;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.transaction.Synchronization;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQXAConnectionTxInterruptTest {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQXAConnectionTxInterruptTest.class);
    long txGenerator = System.currentTimeMillis();
    private BrokerService broker;
    XASession session;
    XAResource resource;
    ActiveMQXAConnection xaConnection;
    Destination dest;

    @Before
    public void startBrokerEtc() throws Exception {
        this.broker = BrokerFactory.createBroker((URI)new URI("broker:(tcp://localhost:0)/BRXA"));
        this.broker.setPersistent(false);
        this.broker.start();
        ActiveMQXAConnectionFactory cf1 = new ActiveMQXAConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri() + ")");
        cf1.setStatsEnabled(true);
        this.xaConnection = (ActiveMQXAConnection)cf1.createConnection();
        this.xaConnection.start();
        this.session = this.xaConnection.createXASession();
        this.resource = this.session.getXAResource();
        this.dest = new ActiveMQQueue("Q");
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.xaConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.broker.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testRollbackAckInterrupted() throws Exception {
        this.publishAMessage();
        this.session = this.xaConnection.createXASession();
        MessageConsumer consumer = this.session.createConsumer(this.dest);
        Xid tid = this.createXid();
        this.resource = this.session.getXAResource();
        this.resource.start(tid, 0);
        ((TransactionContext)this.resource).addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                LOG.info("Interrupting thread: " + Thread.currentThread(), new Throwable("Source"));
                Thread.currentThread().interrupt();
            }
        });
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((Object)this.getName(), (Object)receivedMessage.getText());
        this.resource.end(tid, 0x20000000);
        this.resource.rollback(tid);
        this.session.close();
        Assert.assertTrue((String)"Was interrupted", (boolean)Thread.currentThread().isInterrupted());
    }

    @Test
    public void testCommitAckInterrupted() throws Exception {
        this.publishAMessage();
        this.session = this.xaConnection.createXASession();
        MessageConsumer consumer = this.session.createConsumer(this.dest);
        Xid tid = this.createXid();
        this.resource = this.session.getXAResource();
        this.resource.start(tid, 0);
        ((TransactionContext)this.resource).addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                LOG.info("Interrupting thread: " + Thread.currentThread(), new Throwable("Source"));
                Thread.currentThread().interrupt();
            }
        });
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((Object)this.getName(), (Object)receivedMessage.getText());
        this.resource.end(tid, 0x4000000);
        this.resource.commit(tid, true);
        this.session.close();
    }

    @Test
    public void testInterruptWhilePendingResponseToAck() throws Exception {
        final LinkedList errors = new LinkedList();
        final CountDownLatch blockedServerSize = new CountDownLatch(1);
        final CountDownLatch canContinue = new CountDownLatch(1);
        MutableBrokerFilter filter = (MutableBrokerFilter)this.broker.getBroker().getAdaptor(MutableBrokerFilter.class);
        filter.setNext((Broker)new MutableBrokerFilter(filter.getNext()){

            public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
                blockedServerSize.countDown();
                canContinue.await();
                super.acknowledge(consumerExchange, ack);
            }
        });
        this.publishAMessage();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ActiveMQXAConnectionTxInterruptTest.this.session = ActiveMQXAConnectionTxInterruptTest.this.xaConnection.createXASession();
                    MessageConsumer consumer = ActiveMQXAConnectionTxInterruptTest.this.session.createConsumer(ActiveMQXAConnectionTxInterruptTest.this.dest);
                    Xid tid = ActiveMQXAConnectionTxInterruptTest.this.createXid();
                    ActiveMQXAConnectionTxInterruptTest.this.resource = ActiveMQXAConnectionTxInterruptTest.this.session.getXAResource();
                    ActiveMQXAConnectionTxInterruptTest.this.resource.start(tid, 0);
                    TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
                    Assert.assertNotNull((Object)receivedMessage);
                    Assert.assertEquals((Object)ActiveMQXAConnectionTxInterruptTest.this.getName(), (Object)receivedMessage.getText());
                    try {
                        ActiveMQXAConnectionTxInterruptTest.this.resource.end(tid, 0x4000000);
                        Assert.fail((String)"Expect end to fail");
                    }
                    catch (Throwable expectedWithInterrupt) {
                        Assert.assertTrue((boolean)(expectedWithInterrupt instanceof XAException));
                        ActiveMQXAConnectionTxInterruptTest.this.assertCause(expectedWithInterrupt, new Class[]{InterruptedException.class});
                    }
                    try {
                        ActiveMQXAConnectionTxInterruptTest.this.resource.rollback(tid);
                        Assert.fail((String)"Expect rollback to fail due to connection being closed");
                    }
                    catch (Throwable expectedWithInterrupt) {
                        Assert.assertTrue((boolean)(expectedWithInterrupt instanceof XAException));
                        ActiveMQXAConnectionTxInterruptTest.this.assertCause(expectedWithInterrupt, new Class[]{ConnectionClosedException.class, InterruptedException.class});
                    }
                    ActiveMQXAConnectionTxInterruptTest.this.session.close();
                    Assert.assertTrue((String)"Was interrupted", (boolean)Thread.currentThread().isInterrupted());
                }
                catch (Throwable error) {
                    error.printStackTrace();
                    errors.add(error);
                }
            }
        });
        Assert.assertTrue((String)"got to blocking call", (boolean)blockedServerSize.await(20L, TimeUnit.SECONDS));
        executorService.shutdownNow();
        canContinue.countDown();
        Assert.assertTrue((String)"job done", (boolean)executorService.awaitTermination(20L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("no errors: " + errors), (boolean)errors.isEmpty());
    }

    private void assertCause(Throwable expectedWithInterrupt, Class[] exceptionClazzes) {
        for (Throwable candidate = expectedWithInterrupt; candidate != null; candidate = candidate.getCause()) {
            for (Class exceptionClazz : exceptionClazzes) {
                if (!exceptionClazz.isInstance(candidate)) continue;
                return;
            }
        }
        LOG.error("ex", expectedWithInterrupt);
        Assert.fail((String)("no expected type as cause:" + expectedWithInterrupt));
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            @Override
            public int getFormatId() {
                return 87;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return bs;
            }

            @Override
            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }

    private void publishAMessage() throws IOException, XAException, JMSException {
        Xid tid = this.createXid();
        this.resource.start(tid, 0);
        MessageProducer producer = this.session.createProducer(this.dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText(this.getName());
        producer.send((Message)message);
        this.resource.end(tid, 0x4000000);
        this.resource.commit(tid, true);
        this.session.close();
    }

    private String getName() {
        return this.getClass().getName();
    }
}

