/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyFrameTranslator
implements FrameTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyFrameTranslator.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActiveMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        ActiveMQTextMessage msg;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("amq-msg-type")) {
            String intendedType = headers.get("amq-msg-type");
            if (intendedType.equalsIgnoreCase("text")) {
                ActiveMQTextMessage text = new ActiveMQTextMessage();
                try {
                    text.setText(command.getBody());
                }
                catch (Throwable e) {
                    throw new ProtocolException("Text could not bet set: " + e, false, e);
                }
                msg = text;
            } else {
                if (!intendedType.equalsIgnoreCase("bytes")) throw new ProtocolException("Unsupported message type '" + intendedType + "'", false);
                ActiveMQBytesMessage byteMessage = new ActiveMQBytesMessage();
                byteMessage.writeBytes(command.getContent());
                msg = byteMessage;
            }
        } else if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
            bm.writeBytes(command.getContent());
            msg = bm;
        } else {
            ActiveMQTextMessage text = new ActiveMQTextMessage();
            try {
                text.setText(command.getBody());
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            msg = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, (ActiveMQMessage)msg, this);
        return msg;
    }

    @Override
    public StompFrame convertMessage(ProtocolConverter converter, ActiveMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        if (message.getDataStructureType() == 28) {
            ActiveMQTextMessage msg = (ActiveMQTextMessage)message.copy();
            String messageText = msg.getText();
            if (messageText != null) {
                command.setContent(msg.getText().getBytes(StandardCharsets.UTF_8));
            }
        } else if (message.getDataStructureType() == 24) {
            ActiveMQBytesMessage msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", Integer.toString(data.length));
            command.setContent(data);
        }
        return command;
    }

    @Override
    public String convertDestination(ProtocolConverter converter, Destination d) {
        if (d == null) {
            return null;
        }
        ActiveMQDestination activeMQDestination = (ActiveMQDestination)d;
        String physicalName = activeMQDestination.getPhysicalName();
        String rc = converter.getCreatedTempDestinationName(activeMQDestination);
        if (rc != null) {
            return rc;
        }
        StringBuilder buffer = new StringBuilder();
        if (activeMQDestination.isQueue()) {
            if (activeMQDestination.isTemporary()) {
                buffer.append("/remote-temp-queue/");
            } else {
                buffer.append("/queue/");
            }
        } else if (activeMQDestination.isTemporary()) {
            buffer.append("/remote-temp-topic/");
        } else {
            buffer.append("/topic/");
        }
        buffer.append(physicalName);
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActiveMQDestination convertDestination(ProtocolConverter converter, String name, boolean forceFallback) throws ProtocolException {
        if (name == null) {
            return null;
        }
        String originalName = name;
        String[] destinations = (name = name.trim()).split(",");
        if (destinations == null || destinations.length == 0) {
            destinations = new String[]{name};
        }
        StringBuilder destinationBuilder = new StringBuilder();
        for (int i = 0; i < destinations.length; ++i) {
            ActiveMQDestination converted;
            String destinationName = destinations[i];
            if (destinationName.startsWith("/queue/")) {
                destinationName = destinationName.substring("/queue/".length(), destinationName.length());
                destinationBuilder.append("queue://" + destinationName);
            } else if (destinationName.startsWith("/topic/")) {
                destinationName = destinationName.substring("/topic/".length(), destinationName.length());
                destinationBuilder.append("topic://" + destinationName);
            } else if (destinationName.startsWith("/remote-temp-queue/")) {
                destinationName = destinationName.substring("/remote-temp-queue/".length(), destinationName.length());
                destinationBuilder.append("temp-queue://" + destinationName);
            } else if (destinationName.startsWith("/remote-temp-topic/")) {
                destinationName = destinationName.substring("/remote-temp-topic/".length(), destinationName.length());
                destinationBuilder.append("temp-topic://" + destinationName);
            } else if (destinationName.startsWith("/temp-queue/")) {
                converted = converter.createTempDestination(destinationName, false);
                destinationBuilder.append(converted.getQualifiedName());
            } else if (destinationName.startsWith("/temp-topic/")) {
                converted = converter.createTempDestination(destinationName, true);
                destinationBuilder.append(converted.getQualifiedName());
            } else {
                if (!forceFallback) throw new ProtocolException("Illegal destination name: [" + originalName + "] -- ActiveMQ STOMP destinations must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
                String fallbackName = destinationName;
                if (destinationName.length() == 1) {
                    fallbackName = originalName;
                }
                try {
                    ActiveMQDestination fallback = ActiveMQDestination.getUnresolvableDestinationTransformer().transform(fallbackName);
                    if (fallback != null) {
                        destinationBuilder.append(fallback.getQualifiedName());
                    }
                }
                catch (JMSException e) {
                    throw new ProtocolException("Illegal destination name: [" + fallbackName + "] -- ActiveMQ STOMP destinations must begin with one of: /queue/ /topic/ /temp-queue/ /temp-topic/", false, e);
                }
            }
            if (i >= destinations.length - 1) continue;
            destinationBuilder.append(",");
        }
        LOG.trace("New Composite Destination name: {}", (Object)destinationBuilder);
        return ActiveMQDestination.createDestination((String)destinationBuilder.toString(), (byte)1);
    }
}

