/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import org.apache.activemq.ra.InboundContext;
import org.apache.activemq.ra.InboundContextSupport;
import org.apache.activemq.ra.InboundMessageProducerProxy;

public class InboundSessionProxy
implements Session,
QueueSession,
TopicSession {
    private InboundContext sessionAndProducer;

    public Session getSession() throws JMSException {
        return this.getSessionAndProducer().getSession();
    }

    public QueueSession getQueueSession() throws JMSException {
        Session session = this.getSession();
        if (session instanceof QueueSession) {
            return (QueueSession)session;
        }
        throw new JMSException("The underlying JMS Session does not support QueueSession semantics: " + session);
    }

    public TopicSession getTopicSession() throws JMSException {
        Session session = this.getSession();
        if (session instanceof TopicSession) {
            return (TopicSession)session;
        }
        throw new JMSException("The underlying JMS Session does not support TopicSession semantics: " + session);
    }

    public InboundContext getSessionAndProducer() throws JMSException {
        if (this.sessionAndProducer == null) {
            this.sessionAndProducer = InboundContextSupport.getActiveSessionAndProducer();
            if (this.sessionAndProducer == null) {
                throw new JMSException("No currently active Session. This JMS provider cannot be used outside a MessageListener.onMessage() invocation");
            }
        }
        return this.sessionAndProducer;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new InboundMessageProducerProxy(this.getSessionAndProducer().getMessageProducer(), destination);
    }

    public void close() throws JMSException {
    }

    public void commit() throws JMSException {
    }

    public void rollback() throws JMSException {
    }

    public void recover() throws JMSException {
    }

    public void run() {
        try {
            this.getSession().run();
        }
        catch (JMSException e) {
            throw new RuntimeException("Failed to run() on session due to: " + e, e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getSession().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        return this.getSession().createBrowser(queue, s);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getSession().createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        return this.getSession().createConsumer(destination, s);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        return this.getSession().createConsumer(destination, s, b);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        return this.getSession().createDurableSubscriber(topic, s, s1, b);
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getSession().setMessageListener(messageListener);
    }

    public void unsubscribe(String s) throws JMSException {
        this.getSession().unsubscribe(s);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.getQueueSession().createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String s) throws JMSException {
        return this.getQueueSession().createReceiver(queue, s);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new InboundMessageProducerProxy(this.getSessionAndProducer().getMessageProducer(), (Destination)queue);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.getTopicSession().createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String s, boolean b) throws JMSException {
        return this.getTopicSession().createSubscriber(topic, s, b);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.getTopicSession().createPublisher(topic);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName) is not supported");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName, messageSelector) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name, messageSelector, noLocal) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name, messageSelector) is not supported");
    }

    public String toString() {
        try {
            return "InboundSessionProxy { " + this.getSession() + " }";
        }
        catch (JMSException e) {
            return "InboundSessionProxy { null }";
        }
    }
}

