/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageEndpointProxy;
import org.apache.activemq.ra.ServerSessionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final Log LOG = LogFactory.getLog(ServerSessionPoolImpl.class);
    private final ActiveMQEndpointWorker activeMQAsfEndpointWorker;
    private final int maxSessions;
    private final List<ServerSessionImpl> idleSessions = new ArrayList<ServerSessionImpl>();
    private final List<ServerSessionImpl> activeSessions = new ArrayList<ServerSessionImpl>();
    private final Lock sessionLock = new ReentrantLock();
    private final AtomicBoolean closing = new AtomicBoolean(false);

    public ServerSessionPoolImpl(ActiveMQEndpointWorker activeMQAsfEndpointWorker, int maxSessions) {
        this.activeMQAsfEndpointWorker = activeMQAsfEndpointWorker;
        this.maxSessions = maxSessions;
    }

    private ServerSessionImpl createServerSessionImpl() throws JMSException {
        MessageActivationSpec activationSpec = this.activeMQAsfEndpointWorker.endpointActivationKey.getActivationSpec();
        int acknowledge = this.activeMQAsfEndpointWorker.transacted ? 0 : activationSpec.getAcknowledgeModeForSession();
        ActiveMQSession session = (ActiveMQSession)this.activeMQAsfEndpointWorker.getConnection().createSession(this.activeMQAsfEndpointWorker.transacted, acknowledge);
        try {
            int batchSize = 0;
            if (activationSpec.getEnableBatchBooleanValue()) {
                batchSize = activationSpec.getMaxMessagesPerBatchIntValue();
            }
            if (activationSpec.isUseRAManagedTransactionEnabled()) {
                MessageEndpoint endpoint = this.createEndpoint(null);
                return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, true, batchSize);
            }
            MessageEndpoint endpoint = this.createEndpoint(new LocalAndXATransaction(session.getTransactionContext()));
            return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, false, batchSize);
        }
        catch (UnavailableException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Could not create an endpoint.", (Throwable)e);
            }
            session.close();
            return null;
        }
    }

    private MessageEndpoint createEndpoint(LocalAndXATransaction txResourceProxy) throws UnavailableException {
        MessageEndpoint endpoint = this.activeMQAsfEndpointWorker.endpointFactory.createEndpoint((XAResource)txResourceProxy);
        MessageEndpointProxy endpointProxy = new MessageEndpointProxy(endpoint);
        return endpointProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ServerSession requested.");
        }
        if (this.closing.get()) {
            throw new JMSException("Session Pool Shutting Down.");
        }
        ServerSessionImpl ss = null;
        this.sessionLock.lock();
        try {
            ss = this.getExistingServerSession(false);
        }
        finally {
            this.sessionLock.unlock();
        }
        if (ss != null) {
            return ss;
        }
        ss = this.createServerSessionImpl();
        this.sessionLock.lock();
        try {
            if (ss == null) {
                if (this.activeSessions.isEmpty() && this.idleSessions.isEmpty()) {
                    throw new JMSException("Endpoint factory did not allow creation of any endpoints.");
                }
                ss = this.getExistingServerSession(true);
            } else {
                this.activeSessions.add(ss);
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created a new session: " + ss));
        }
        return ss;
    }

    private ServerSessionImpl getExistingServerSession(boolean force) {
        ServerSessionImpl ss = null;
        if (this.idleSessions.size() > 0) {
            ss = this.idleSessions.remove(this.idleSessions.size() - 1);
        }
        if (ss != null) {
            this.activeSessions.add(ss);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using idle session: " + ss));
            }
        } else if (force || this.activeSessions.size() >= this.maxSessions) {
            ss = this.getExistingActiveServerSession();
        }
        return ss;
    }

    private ServerSessionImpl getExistingActiveServerSession() {
        ServerSessionImpl ss = null;
        if (!this.activeSessions.isEmpty()) {
            if (this.activeSessions.size() > 1) {
                ss = this.activeSessions.remove(0);
                this.activeSessions.add(ss);
            } else {
                ss = this.activeSessions.get(0);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reusing an active session: " + ss));
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(ServerSessionImpl ss) {
        this.sessionLock.lock();
        this.activeSessions.remove(ss);
        try {
            if (ss.isStale()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Discarding stale ServerSession to be returned to pool: " + ss));
                }
                ss.close();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ServerSession returned to pool: " + ss));
                }
                this.idleSessions.add(ss);
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromPool(ServerSessionImpl ss) {
        this.sessionLock.lock();
        try {
            this.activeSessions.remove(ss);
        }
        finally {
            this.sessionLock.unlock();
        }
        try {
            ActiveMQSession session = (ActiveMQSession)ss.getSession();
            List l = session.getUnconsumedMessages();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.dispatchToSession((MessageDispatch)i.next());
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error redispatching unconsumed messages from stale session", t);
        }
        ss.close();
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    private void dispatchToSession(MessageDispatch messageDispatch) throws JMSException {
        ServerSession serverSession = this.getServerSession();
        Session s = serverSession.getSession();
        ActiveMQSession session = null;
        if (s instanceof ActiveMQSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQQueueSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQTopicSession) {
            session = (ActiveMQSession)s;
        } else {
            this.activeMQAsfEndpointWorker.getConnection().onAsyncException((Throwable)new JMSException("Session pool provided an invalid session type: " + s.getClass()));
        }
        session.dispatch(messageDispatch);
        serverSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closing.set(true);
        int activeCount = this.closeIdleSessions();
        while (activeCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Active Sessions = " + activeCount));
            }
            try {
                AtomicBoolean atomicBoolean = this.closing;
                synchronized (atomicBoolean) {
                    this.closing.wait(250L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            activeCount = this.closeIdleSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int closeIdleSessions() {
        this.sessionLock.lock();
        try {
            for (ServerSessionImpl ss : this.idleSessions) {
                ss.close();
            }
            this.idleSessions.clear();
            int n = this.activeSessions.size();
            return n;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public void setClosing(boolean closing) {
        this.closing.set(closing);
    }
}

