/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.IAmqpProtocolConverter;

public class AMQPProtocolDiscriminator
implements IAmqpProtocolConverter {
    private final AmqpTransport transport;
    private static final ArrayList<Discriminator> DISCRIMINATORS = new ArrayList();
    private static final ArrayList<Command> pendingCommands;

    public AMQPProtocolDiscriminator(AmqpTransport transport) {
        this.transport = transport;
    }

    @Override
    public void onAMQPData(Object command) throws Exception {
        IAmqpProtocolConverter next;
        if (command.getClass() == AmqpHeader.class) {
            AmqpHeader header = (AmqpHeader)command;
            Discriminator match = null;
            for (Discriminator discriminator : DISCRIMINATORS) {
                if (!discriminator.matches(header)) continue;
                match = discriminator;
            }
            if (match == null) {
                match = DISCRIMINATORS.get(0);
            }
            next = match.create(this.transport);
            this.transport.setProtocolConverter(next);
            for (Command send : pendingCommands) {
                next.onActiveMQCommand(send);
            }
        } else {
            throw new IllegalStateException();
        }
        pendingCommands.clear();
        next.onAMQPData(command);
    }

    @Override
    public void onAMQPException(IOException error) {
    }

    @Override
    public void onActiveMQCommand(Command command) throws Exception {
        pendingCommands.add(command);
    }

    @Override
    public void updateTracer() {
    }

    static {
        DISCRIMINATORS.add(new Discriminator(){

            @Override
            public IAmqpProtocolConverter create(AmqpTransport transport) {
                return new AmqpProtocolConverter(transport);
            }

            @Override
            public boolean matches(AmqpHeader header) {
                switch (header.getProtocolId()) {
                    case 0: 
                    case 3: {
                        if (header.getMajor() != 1 || header.getMinor() != 0 || header.getRevision() != 0) break;
                        return true;
                    }
                }
                return false;
            }
        });
        pendingCommands = new ArrayList();
    }

    static interface Discriminator {
        public boolean matches(AmqpHeader var1);

        public IAmqpProtocolConverter create(AmqpTransport var1);
    }
}

