/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.List;
import java.util.Locale;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class DstatCommand
extends AbstractJmxCommand {
    private static final String queryString = "type=Broker,brokerName=*,destinationType=%1,destinationName=*,*";
    protected String[] helpFile = new String[]{"Task Usage: activemq-admin dstat [dstat-options] [destination-type]", "Description: Performs a predefined query that displays useful statistics regarding the specified .", "             destination type (Queues or Topics) and displays those results in a tabular format.", "             If no broker name is specified, it will try and select from all registered brokers.", "", "dstat Options:", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --pid <pid>                   Set the pid to connect to (only on Sun JVM).", "    --jmxuser <user>              Set the JMX user used for authenticating.", "    --jmxpassword <password>      Set the JMX password used for authenticating.", "    --jmxlocal                    Use the local JMX server instead of a remote one.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the query broker help information.", "", "Examples:", "    activemq-admin dstat queues", "        - Display a tabular summary of statistics for the queues on the broker.", "    activemq-admin dstat topics", "        - Display a tabular summary of statistics for the queues on the broker."};

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        try {
            if (tokens.contains("topics")) {
                this.displayTopicStats();
            } else if (tokens.contains("queues")) {
                this.displayQueueStats();
            } else {
                this.displayAllDestinations();
            }
        }
        catch (Exception e) {
            this.context.printException(new RuntimeException("Failed to execute dstat task. Reason: " + e));
            throw new Exception(e);
        }
    }

    private void displayAllDestinations() throws Exception {
        String query = JmxMBeansUtil.createQueryString(queryString, "*");
        List queueList = JmxMBeansUtil.queryMBeans(this.createJmxConnection(), query);
        String header = "%-50s  %10s  %10s  %10s  %10s  %10s  %10s";
        String tableRow = "%-50s  %10d  %10d  %10d  %10d  %10d  %10d";
        this.context.print(String.format(Locale.US, "%-50s  %10s  %10s  %10s  %10s  %10s  %10s", "Name", "Queue Size", "Producer #", "Consumer #", "Enqueue #", "Dequeue #", "Memory %"));
        for (Object view : queueList) {
            ObjectName queueName = ((ObjectInstance)view).getObjectName();
            QueueViewMBean queueView = MBeanServerInvocationHandler.newProxyInstance(this.createJmxConnection(), queueName, QueueViewMBean.class, true);
            this.context.print(String.format(Locale.US, "%-50s  %10d  %10d  %10d  %10d  %10d  %10d", queueView.getName(), queueView.getQueueSize(), queueView.getProducerCount(), queueView.getConsumerCount(), queueView.getEnqueueCount(), queueView.getDequeueCount(), queueView.getMemoryPercentUsage()));
        }
    }

    private void displayQueueStats() throws Exception {
        String query = JmxMBeansUtil.createQueryString(queryString, "Queue");
        List queueList = JmxMBeansUtil.queryMBeans(this.createJmxConnection(), query);
        String header = "%-50s  %10s  %10s  %10s  %10s  %10s  %10s";
        String tableRow = "%-50s  %10d  %10d  %10d  %10d  %10d  %10d";
        this.context.print(String.format(Locale.US, "%-50s  %10s  %10s  %10s  %10s  %10s  %10s", "Name", "Queue Size", "Producer #", "Consumer #", "Enqueue #", "Dequeue #", "Memory %"));
        for (Object view : queueList) {
            ObjectName queueName = ((ObjectInstance)view).getObjectName();
            QueueViewMBean queueView = MBeanServerInvocationHandler.newProxyInstance(this.createJmxConnection(), queueName, QueueViewMBean.class, true);
            this.context.print(String.format(Locale.US, "%-50s  %10d  %10d  %10d  %10d  %10d  %10d", queueView.getName(), queueView.getQueueSize(), queueView.getProducerCount(), queueView.getConsumerCount(), queueView.getEnqueueCount(), queueView.getDequeueCount(), queueView.getMemoryPercentUsage()));
        }
    }

    private void displayTopicStats() throws Exception {
        String query = JmxMBeansUtil.createQueryString(queryString, "Topic");
        List topicsList = JmxMBeansUtil.queryMBeans(this.createJmxConnection(), query);
        String header = "%-50s  %10s  %10s  %10s  %10s  %10s  %10s";
        String tableRow = "%-50s  %10d  %10d  %10d  %10d  %10d  %10d";
        this.context.print(String.format(Locale.US, "%-50s  %10s  %10s  %10s  %10s  %10s  %10s", "Name", "Queue Size", "Producer #", "Consumer #", "Enqueue #", "Dequeue #", "Memory %"));
        for (Object view : topicsList) {
            ObjectName topicName = ((ObjectInstance)view).getObjectName();
            TopicViewMBean topicView = MBeanServerInvocationHandler.newProxyInstance(this.createJmxConnection(), topicName, TopicViewMBean.class, true);
            this.context.print(String.format(Locale.US, "%-50s  %10d  %10d  %10d  %10d  %10d  %10d", topicView.getName(), topicView.getQueueSize(), topicView.getProducerCount(), topicView.getConsumerCount(), topicView.getEnqueueCount(), topicView.getDequeueCount(), topicView.getMemoryPercentUsage()));
        }
    }

    @Override
    public String getName() {
        return "dstat";
    }

    @Override
    public String getOneLineDescription() {
        return "Performs a predefined query that displays useful tabular statistics regarding the specified destination type";
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

