/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;

public abstract class AbstractResourceProvider
implements InternalResourceProvider {
    @Override
    public Resource createResource(String path) {
        if (path == null) {
            return null;
        }
        URI uri = URI.create(path).normalize();
        if (uri.isAbsolute()) {
            throw new IllegalArgumentException(path + " => only path with no scheme are supported...");
        }
        path = uri.toString();
        return this.doBuildResource(PathUtils.addLeadingSlash(path));
    }

    @Override
    public InternalResource getParentResource(InternalResource resource) {
        String parentPath = PathUtils.getParentPath(resource.getPath());
        if (parentPath.equals(resource.getPath())) {
            return resource;
        }
        return this.doBuildResource(parentPath);
    }

    @Override
    public InternalResource getRootResource() {
        return this.doBuildResource("/");
    }

    @Override
    public final InternalResource createRelative(InternalResource resource, String relativePath) {
        if (relativePath == null) {
            return null;
        }
        URI relativeURI = URI.create(relativePath).normalize();
        if (relativeURI.isAbsolute()) {
            throw new IllegalArgumentException(relativePath + " is absolute");
        }
        relativePath = relativeURI.getPath();
        if (!"/".equals(relativePath)) {
            relativePath = PathUtils.removeLeadingSlash(relativePath);
        }
        if ("".equals(relativePath)) {
            return resource;
        }
        if ("..".equals(relativePath)) {
            return this.getParentResource(resource);
        }
        if (relativePath.startsWith("../")) {
            return (InternalResource)this.getParentResource(resource).createRelative(relativePath.substring(3));
        }
        return this.doBuildResource(PathUtils.addPaths(resource.getPath(), relativePath));
    }

    @Override
    public InternalResource chroot(InternalResource resource) {
        String path = resource.getPath();
        if (resource.isDirectory()) {
            return this.doCreateResourceProvider(path).getRootResource();
        }
        return (InternalResource)resource.chroot("..").createRelative(resource.getFilename());
    }

    @Override
    public InternalResource[] list(InternalResource resource, final ResourceFilter filter) throws IOException {
        final ArrayList resources = new ArrayList();
        String path = PathUtils.addTrailingSlash(resource.getPath());
        if (this.doList(path, new ResourceFilter(){

            @Override
            public boolean accept(Resource resource) {
                boolean res = filter.accept(resource);
                if (res) {
                    resources.add(resource);
                }
                return res;
            }
        })) {
            return resources.toArray(new InternalResource[resources.size()]);
        }
        return null;
    }
}

