/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.ProtonUnsupportedOperationException;
import org.apache.qpid.proton.engine.Ssl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.PlainTransportWrapper;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngineProvider;
import org.apache.qpid.proton.engine.impl.ssl.SimpleSslTransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslHandshakeSniffingTransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SslImpl
implements Ssl {
    private SslTransportWrapper _unsecureClientAwareTransportWrapper;
    private final SslDomain _domain;
    private final ProtonSslEngineProvider _protonSslEngineProvider;
    private final SslPeerDetails _peerDetails;

    public SslImpl(SslDomain domain, SslPeerDetails peerDetails) {
        this._domain = domain;
        this._protonSslEngineProvider = (ProtonSslEngineProvider)((Object)domain);
        this._peerDetails = peerDetails;
    }

    public TransportWrapper wrap(TransportInput inputProcessor, TransportOutput outputProcessor) {
        if (this._unsecureClientAwareTransportWrapper != null) {
            throw new IllegalStateException("Transport already wrapped");
        }
        this._unsecureClientAwareTransportWrapper = new UnsecureClientAwareTransportWrapper(inputProcessor, outputProcessor);
        return this._unsecureClientAwareTransportWrapper;
    }

    @Override
    public String getCipherName() {
        if (this._unsecureClientAwareTransportWrapper == null) {
            throw new IllegalStateException("Transport wrapper is uninitialised");
        }
        return this._unsecureClientAwareTransportWrapper.getCipherName();
    }

    @Override
    public String getProtocolName() {
        if (this._unsecureClientAwareTransportWrapper == null) {
            throw new IllegalStateException("Transport wrapper is uninitialised");
        }
        return this._unsecureClientAwareTransportWrapper.getProtocolName();
    }

    @Override
    public void setPeerHostname(String hostname) {
        throw new ProtonUnsupportedOperationException();
    }

    @Override
    public String getPeerHostname() {
        throw new ProtonUnsupportedOperationException();
    }

    private class UnsecureClientAwareTransportWrapper
    implements SslTransportWrapper {
        private final TransportInput _inputProcessor;
        private final TransportOutput _outputProcessor;
        private SslTransportWrapper _transportWrapper;

        private UnsecureClientAwareTransportWrapper(TransportInput inputProcessor, TransportOutput outputProcessor) {
            this._inputProcessor = inputProcessor;
            this._outputProcessor = outputProcessor;
        }

        @Override
        public int capacity() {
            this.initTransportWrapperOnFirstIO();
            return this._transportWrapper.capacity();
        }

        @Override
        public ByteBuffer tail() {
            this.initTransportWrapperOnFirstIO();
            return this._transportWrapper.tail();
        }

        @Override
        public void process() throws TransportException {
            this.initTransportWrapperOnFirstIO();
            this._transportWrapper.process();
        }

        @Override
        public void close_tail() {
            this.initTransportWrapperOnFirstIO();
            this._transportWrapper.process();
        }

        @Override
        public int pending() {
            this.initTransportWrapperOnFirstIO();
            return this._transportWrapper.pending();
        }

        @Override
        public ByteBuffer head() {
            this.initTransportWrapperOnFirstIO();
            return this._transportWrapper.head();
        }

        @Override
        public void pop(int bytes) {
            this.initTransportWrapperOnFirstIO();
            this._transportWrapper.pop(bytes);
        }

        @Override
        public void close_head() {
            this.initTransportWrapperOnFirstIO();
            this._transportWrapper.close_head();
        }

        @Override
        public String getCipherName() {
            if (this._transportWrapper == null) {
                return null;
            }
            return this._transportWrapper.getCipherName();
        }

        @Override
        public String getProtocolName() {
            if (this._transportWrapper == null) {
                return null;
            }
            return this._transportWrapper.getProtocolName();
        }

        private void initTransportWrapperOnFirstIO() {
            if (this._transportWrapper == null) {
                SimpleSslTransportWrapper sslTransportWrapper = new SimpleSslTransportWrapper(SslImpl.this._protonSslEngineProvider.createSslEngine(SslImpl.this._peerDetails), this._inputProcessor, this._outputProcessor);
                if (SslImpl.this._domain.allowUnsecuredClient()) {
                    PlainTransportWrapper plainTransportWrapper = new PlainTransportWrapper(this._outputProcessor, this._inputProcessor);
                    this._transportWrapper = new SslHandshakeSniffingTransportWrapper(sslTransportWrapper, plainTransportWrapper);
                } else {
                    this._transportWrapper = sslTransportWrapper;
                }
            }
        }
    }
}

