/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.qpid.proton.jms.JMSVendor;

public class ActiveMQJMSVendor
extends JMSVendor {
    public static final ActiveMQJMSVendor INSTANCE = new ActiveMQJMSVendor();

    private ActiveMQJMSVendor() {
    }

    @Override
    public BytesMessage createBytesMessage() {
        return new ActiveMQBytesMessage();
    }

    @Override
    public StreamMessage createStreamMessage() {
        return new ActiveMQStreamMessage();
    }

    @Override
    public Message createMessage() {
        return new ActiveMQMessage();
    }

    @Override
    public TextMessage createTextMessage() {
        return new ActiveMQTextMessage();
    }

    @Override
    public ObjectMessage createObjectMessage() {
        return new ActiveMQObjectMessage();
    }

    @Override
    public MapMessage createMapMessage() {
        return new ActiveMQMapMessage();
    }

    @Override
    public Destination createDestination(String name) {
        return super.createDestination(name, Destination.class);
    }

    @Override
    public <T extends Destination> T createDestination(String name, Class<T> kind) {
        if (kind == Queue.class) {
            return (T)((Destination)kind.cast(new ActiveMQQueue(name)));
        }
        if (kind == Topic.class) {
            return (T)((Destination)kind.cast(new ActiveMQTopic(name)));
        }
        if (kind == TemporaryQueue.class) {
            return (T)((Destination)kind.cast(new ActiveMQTempQueue(name)));
        }
        if (kind == TemporaryTopic.class) {
            return (T)((Destination)kind.cast(new ActiveMQTempTopic(name)));
        }
        return (T)((Destination)kind.cast(ActiveMQDestination.createDestination(name, (byte)1)));
    }

    @Override
    public void setJMSXUserID(Message msg, String value) {
        ((ActiveMQMessage)msg).setUserID(value);
    }

    @Override
    public void setJMSXGroupID(Message msg, String value) {
        ((ActiveMQMessage)msg).setGroupID(value);
    }

    @Override
    public void setJMSXGroupSequence(Message msg, int value) {
        ((ActiveMQMessage)msg).setGroupSequence(value);
    }

    @Override
    public void setJMSXDeliveryCount(Message msg, long value) {
        ((ActiveMQMessage)msg).setRedeliveryCounter((int)value);
    }

    @Override
    public String toAddress(Destination dest) {
        return ((ActiveMQDestination)dest).getQualifiedName();
    }
}

