/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.CompositeDestinationInterceptor;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.CompositeQueue;
import org.apache.activemq.broker.region.virtual.CompositeTopic;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.plugin.jmx.RuntimeConfigurationView;
import org.apache.activemq.schema.core.DtoAuthorizationEntry;
import org.apache.activemq.schema.core.DtoAuthorizationMap;
import org.apache.activemq.schema.core.DtoAuthorizationPlugin;
import org.apache.activemq.schema.core.DtoBroker;
import org.apache.activemq.schema.core.DtoCompositeQueue;
import org.apache.activemq.schema.core.DtoCompositeTopic;
import org.apache.activemq.schema.core.DtoNetworkConnector;
import org.apache.activemq.schema.core.DtoPolicyEntry;
import org.apache.activemq.schema.core.DtoPolicyMap;
import org.apache.activemq.schema.core.DtoQueue;
import org.apache.activemq.schema.core.DtoTopic;
import org.apache.activemq.schema.core.DtoVirtualDestinationInterceptor;
import org.apache.activemq.schema.core.DtoVirtualTopic;
import org.apache.activemq.security.AuthorizationBroker;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;
import org.apache.activemq.security.XBeanAuthorizationEntry;
import org.apache.activemq.security.XBeanAuthorizationMap;
import org.apache.activemq.spring.Utils;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RuntimeConfigurationBroker
extends BrokerFilter {
    public static final Logger LOG = LoggerFactory.getLogger(RuntimeConfigurationBroker.class);
    public static final String objectNamePropsAppendage = ",service=RuntimeConfiguration,name=Plugin";
    private final ReentrantReadWriteLock addDestinationBarrier = new ReentrantReadWriteLock();
    PropertiesPlaceHolderUtil placeHolderUtil = null;
    private long checkPeriod;
    private long lastModified = -1L;
    private Resource configToMonitor;
    private DtoBroker currentConfiguration;
    private Runnable monitorTask;
    private ConcurrentLinkedQueue<Runnable> destinationInterceptorUpdateWork = new ConcurrentLinkedQueue();
    private ObjectName objectName;
    private String infoString;
    private Schema schema;

    public RuntimeConfigurationBroker(Broker next) {
        super(next);
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            BrokerContext brokerContext = this.next.getBrokerService().getBrokerContext();
            if (brokerContext != null) {
                this.configToMonitor = Utils.resourceFromString(brokerContext.getConfigurationUrl());
                this.info("Configuration " + this.configToMonitor);
            } else {
                LOG.error("Null BrokerContext; impossible to determine configuration url resource from broker, updates cannot be tracked");
            }
        }
        catch (Exception error) {
            LOG.error("failed to determine configuration url resource from broker, updates cannot be tracked", (Throwable)error);
        }
        this.currentConfiguration = this.loadConfiguration(this.configToMonitor);
        this.monitorModification(this.configToMonitor);
        this.registerMbean();
    }

    @Override
    public void stop() throws Exception {
        if (this.monitorTask != null) {
            try {
                this.getBrokerService().getScheduler().cancel(this.monitorTask);
            }
            catch (Exception letsNotStopStop) {
                LOG.warn("Failed to cancel config monitor task", (Throwable)letsNotStopStop);
            }
        }
        this.unregisterMbean();
        super.stop();
    }

    private void registerMbean() {
        if (this.getBrokerService().isUseJmx()) {
            ManagementContext managementContext = this.getBrokerService().getManagementContext();
            try {
                this.objectName = new ObjectName(this.getBrokerService().getBrokerObjectName().toString() + objectNamePropsAppendage);
                managementContext.registerMBean(new RuntimeConfigurationView(this), this.objectName);
            }
            catch (Exception ignored) {
                LOG.debug("failed to register RuntimeConfigurationMBean", (Throwable)ignored);
            }
        }
    }

    private void unregisterMbean() {
        if (this.objectName != null) {
            try {
                this.getBrokerService().getManagementContext().unregisterMBean(this.objectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        Runnable work = this.destinationInterceptorUpdateWork.poll();
        if (work != null) {
            try {
                this.addDestinationBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.destinationInterceptorUpdateWork.poll()) != null);
                Destination destination2 = super.addDestination(context, destination, createIfTemporary);
                return destination2;
            }
            finally {
                this.addDestinationBarrier.writeLock().unlock();
            }
        }
        try {
            this.addDestinationBarrier.readLock().lockInterruptibly();
            Destination destination3 = super.addDestination(context, destination, createIfTemporary);
            return destination3;
        }
        finally {
            this.addDestinationBarrier.readLock().unlock();
        }
    }

    public String updateNow() {
        LOG.info("Manual configuration update triggered");
        this.infoString = "";
        this.applyModifications(this.configToMonitor);
        String result = this.infoString;
        this.infoString = null;
        return result;
    }

    private void monitorModification(final Resource configToMonitor) {
        this.monitorTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (configToMonitor.lastModified() > RuntimeConfigurationBroker.this.lastModified) {
                        RuntimeConfigurationBroker.this.applyModifications(configToMonitor);
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to determine lastModified time on configuration: " + configToMonitor, e);
                }
            }
        };
        if (this.lastModified > 0L && this.checkPeriod > 0L) {
            this.getBrokerService().getScheduler().executePeriodically(this.monitorTask, this.checkPeriod);
            this.info("Monitoring for updates (every " + this.checkPeriod + "millis) : " + configToMonitor + ", lastUpdate: " + new Date(this.lastModified));
        }
    }

    private void info(String s) {
        LOG.info(s);
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ";";
        }
    }

    private void info(String s, Throwable t) {
        LOG.info(s, t);
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ", " + t;
            this.infoString = this.infoString + ";";
        }
    }

    private void applyModifications(Resource configToMonitor) {
        DtoBroker changed2 = this.loadConfiguration(configToMonitor);
        if (changed2 != null && !this.currentConfiguration.equals(changed2)) {
            LOG.info("change in " + configToMonitor + " at: " + new Date(this.lastModified));
            LOG.debug("current:" + this.currentConfiguration);
            LOG.debug("new    :" + changed2);
            this.processSelectiveChanges(this.currentConfiguration, changed2);
            this.currentConfiguration = changed2;
        } else {
            this.info("No material change to configuration in " + configToMonitor + " at: " + new Date(this.lastModified));
        }
    }

    private void processSelectiveChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration) {
        for (Class upDatable : new Class[]{DtoBroker.DestinationPolicy.class, DtoBroker.NetworkConnectors.class, DtoBroker.DestinationInterceptors.class, DtoBroker.Plugins.class}) {
            this.processChanges(currentConfiguration, modifiedConfiguration, upDatable);
        }
    }

    private void processChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration, Class upDatable) {
        int currentIndex;
        List<Object> modified;
        List<Object> current = this.filter(currentConfiguration, upDatable);
        if (((Object)current).equals(modified = this.filter(modifiedConfiguration, upDatable))) {
            LOG.debug("no changes to " + upDatable.getSimpleName());
            return;
        }
        this.info("changes to " + upDatable.getSimpleName());
        int modIndex = 0;
        for (currentIndex = 0; modIndex < modified.size() && currentIndex < current.size(); ++modIndex, ++currentIndex) {
            this.applyModifications(this.getContents(current.get(currentIndex)), this.getContents(modified.get(modIndex)));
        }
        while (modIndex < modified.size()) {
            for (Object nc : this.getContents(modified.get(modIndex))) {
                this.addNew(nc);
            }
            ++modIndex;
        }
        while (currentIndex < current.size()) {
            for (Object nc : this.getContents(current.get(currentIndex))) {
                this.remove(nc);
            }
            ++currentIndex;
        }
    }

    private List<Object> getContents(Object o) {
        List<Object> answer = new ArrayList<Object>();
        try {
            Object val = o.getClass().getMethod("getContents", new Class[0]).invoke(o, new Object[0]);
            if (val instanceof List) {
                answer = (List)val;
            } else {
                answer.add(val);
            }
        }
        catch (NoSuchMethodException mappingIncomplete) {
            LOG.debug(o + " has no modifiable elements");
        }
        catch (Exception e) {
            this.info("Failed to access getContents for " + o + ", runtime modifications not supported", e);
        }
        return answer;
    }

    private void applyModifications(List<Object> current, List<Object> modification) {
        int currentIndex;
        int modIndex = 0;
        for (currentIndex = 0; modIndex < modification.size() && currentIndex < current.size(); ++modIndex, ++currentIndex) {
            Object candidate;
            Object existing = current.get(currentIndex);
            if (existing.equals(candidate = modification.get(modIndex))) continue;
            this.info("modification to:" + existing + " , with: " + candidate);
            this.modify(existing, candidate);
        }
        while (modIndex < modification.size()) {
            this.addNew(modification.get(modIndex));
            ++modIndex;
        }
        while (currentIndex < current.size()) {
            this.remove(current.get(currentIndex));
            ++currentIndex;
        }
    }

    private void modify(Object existing, Object candidate) {
        if (candidate instanceof DtoAuthorizationPlugin) {
            try {
                AuthorizationBroker authorizationBroker = (AuthorizationBroker)this.getBrokerService().getBroker().getAdaptor(AuthorizationBroker.class);
                authorizationBroker.setAuthorizationMap(this.fromDto(this.filter(candidate, DtoAuthorizationPlugin.Map.class)));
            }
            catch (Exception e) {
                this.info("failed to apply modified AuthorizationMap to AuthorizationBroker", e);
            }
        } else if (candidate instanceof DtoPolicyMap) {
            List<Object> existingEntries = this.filter(existing, DtoPolicyMap.PolicyEntries.class);
            List<Object> candidateEntries = this.filter(candidate, DtoPolicyMap.PolicyEntries.class);
            this.applyModifications(this.getContents(existingEntries.get(0)), this.getContents(candidateEntries.get(0)));
        } else if (candidate instanceof DtoPolicyEntry) {
            PolicyEntry updatedEntry;
            PolicyMap existingMap = this.getBrokerService().getDestinationPolicy();
            Set existingEntry = existingMap.get((updatedEntry = this.fromDto(candidate, new PolicyEntry())).getDestination());
            if (existingEntry.size() == 1) {
                updatedEntry = this.fromDto(candidate, (PolicyEntry)existingEntry.iterator().next());
                this.applyRetrospectively(updatedEntry);
                this.info("updated policy for: " + updatedEntry.getDestination());
            } else {
                this.info("cannot modify policy matching multiple destinations: " + existingEntry + ", destination:" + updatedEntry.getDestination());
            }
        } else {
            this.remove(existing);
            this.addNew(candidate);
        }
    }

    private void applyRetrospectively(PolicyEntry updatedEntry) {
        RegionBroker regionBroker = (RegionBroker)this.getBrokerService().getRegionBroker();
        for (Destination destination : regionBroker.getDestinations(updatedEntry.getDestination())) {
            if (destination.getActiveMQDestination().isQueue()) {
                updatedEntry.update((Queue)destination);
            } else if (destination.getActiveMQDestination().isTopic()) {
                updatedEntry.update((Topic)destination);
            }
            LOG.debug("applied update to:" + destination);
        }
    }

    private AuthorizationMap fromDto(List<Object> map2) {
        XBeanAuthorizationMap xBeanAuthorizationMap = new XBeanAuthorizationMap();
        for (Object o : map2) {
            if (o instanceof DtoAuthorizationPlugin.Map) {
                DtoAuthorizationPlugin.Map dtoMap = (DtoAuthorizationPlugin.Map)o;
                LinkedList<DestinationMapEntry> entries = new LinkedList<DestinationMapEntry>();
                for (Object authMap : this.filter(dtoMap.getAuthorizationMap(), DtoAuthorizationMap.AuthorizationEntries.class)) {
                    for (Object entry : this.filter(this.getContents(authMap), DtoAuthorizationEntry.class)) {
                        entries.add(this.fromDto(entry, new XBeanAuthorizationEntry()));
                    }
                }
                xBeanAuthorizationMap.setAuthorizationEntries(entries);
                try {
                    xBeanAuthorizationMap.afterPropertiesSet();
                }
                catch (Exception e) {
                    this.info("failed to update xBeanAuthorizationMap auth entries:", e);
                }
                for (Object entry : this.filter(dtoMap.getAuthorizationMap(), DtoAuthorizationMap.TempDestinationAuthorizationEntry.class)) {
                    DtoAuthorizationMap.TempDestinationAuthorizationEntry dtoEntry = (DtoAuthorizationMap.TempDestinationAuthorizationEntry)entry;
                    xBeanAuthorizationMap.setTempDestinationAuthorizationEntry(this.fromDto(dtoEntry.getTempDestinationAuthorizationEntry(), new TempDestinationAuthorizationEntry()));
                }
                continue;
            }
            this.info("No support for updates to: " + o);
        }
        return xBeanAuthorizationMap;
    }

    private void remove(Object o) {
        if (o instanceof DtoNetworkConnector) {
            DtoNetworkConnector toRemove = (DtoNetworkConnector)o;
            for (NetworkConnector existingCandidate : this.getBrokerService().getNetworkConnectors()) {
                if (!this.configMatch(toRemove, existingCandidate) || !this.getBrokerService().removeNetworkConnector(existingCandidate)) continue;
                try {
                    existingCandidate.stop();
                    this.info("stopped and removed networkConnector: " + existingCandidate);
                }
                catch (Exception e) {
                    this.info("Failed to stop removed network connector: " + existingCandidate);
                }
            }
        } else if (o instanceof DtoVirtualDestinationInterceptor) {
            this.destinationInterceptorUpdateWork.add(new Runnable(){

                @Override
                public void run() {
                    ArrayList<DestinationInterceptor> interceptorsList = new ArrayList<DestinationInterceptor>();
                    for (DestinationInterceptor candidate : RuntimeConfigurationBroker.this.getBrokerService().getDestinationInterceptors()) {
                        if (candidate instanceof VirtualDestinationInterceptor) continue;
                        interceptorsList.add(candidate);
                    }
                    DestinationInterceptor[] destinationInterceptors = interceptorsList.toArray(new DestinationInterceptor[0]);
                    RuntimeConfigurationBroker.this.getBrokerService().setDestinationInterceptors(destinationInterceptors);
                    ((CompositeDestinationInterceptor)((RegionBroker)RuntimeConfigurationBroker.this.getBrokerService().getRegionBroker()).getDestinationInterceptor()).setInterceptors(destinationInterceptors);
                    RuntimeConfigurationBroker.this.info("removed VirtualDestinationInterceptor from: " + interceptorsList);
                }
            });
        } else {
            this.info("No runtime support for removal of: " + o);
        }
    }

    private boolean configMatch(DtoNetworkConnector dto, NetworkConnector candidate) {
        TreeMap dtoProps = new TreeMap();
        IntrospectionSupport.getProperties(dto, dtoProps, null);
        TreeMap candidateProps = new TreeMap();
        IntrospectionSupport.getProperties(candidate, candidateProps, null);
        for (String key : dtoProps.keySet()) {
            if (candidateProps.containsKey(key) && ((String)candidateProps.get(key)).equals(dtoProps.get(key))) continue;
            return false;
        }
        return true;
    }

    private void addNew(Object o) {
        if (o instanceof DtoNetworkConnector) {
            DtoNetworkConnector networkConnector = (DtoNetworkConnector)o;
            if (networkConnector.getUri() != null) {
                try {
                    DiscoveryNetworkConnector nc = this.fromDto(networkConnector, new DiscoveryNetworkConnector());
                    this.getBrokerService().addNetworkConnector(nc);
                    nc.start();
                    this.info("started new network connector: " + nc);
                }
                catch (Exception e) {
                    this.info("Failed to add new networkConnector " + networkConnector, e);
                }
            }
        } else if (o instanceof DtoVirtualDestinationInterceptor) {
            final DtoVirtualDestinationInterceptor dto = (DtoVirtualDestinationInterceptor)o;
            this.destinationInterceptorUpdateWork.add(new Runnable(){

                @Override
                public void run() {
                    boolean updatedExistingInterceptor = false;
                    for (DestinationInterceptor destinationInterceptor : RuntimeConfigurationBroker.this.getBrokerService().getDestinationInterceptors()) {
                        if (!(destinationInterceptor instanceof VirtualDestinationInterceptor)) continue;
                        VirtualDestinationInterceptor virtualDestinationInterceptor = (VirtualDestinationInterceptor)destinationInterceptor;
                        virtualDestinationInterceptor.setVirtualDestinations(RuntimeConfigurationBroker.this.fromDto(dto));
                        RuntimeConfigurationBroker.this.info("applied updates to: " + virtualDestinationInterceptor);
                        updatedExistingInterceptor = true;
                    }
                    if (!updatedExistingInterceptor) {
                        VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
                        virtualDestinationInterceptor.setVirtualDestinations(RuntimeConfigurationBroker.this.fromDto(dto));
                        ArrayList<DestinationInterceptor> interceptorsList = new ArrayList<DestinationInterceptor>();
                        interceptorsList.addAll(Arrays.asList(RuntimeConfigurationBroker.this.getBrokerService().getDestinationInterceptors()));
                        interceptorsList.add(virtualDestinationInterceptor);
                        DestinationInterceptor[] destinationInterceptors = interceptorsList.toArray(new DestinationInterceptor[0]);
                        RuntimeConfigurationBroker.this.getBrokerService().setDestinationInterceptors(destinationInterceptors);
                        RegionBroker regionBroker = (RegionBroker)RuntimeConfigurationBroker.this.getBrokerService().getRegionBroker();
                        ((CompositeDestinationInterceptor)regionBroker.getDestinationInterceptor()).setInterceptors(destinationInterceptors);
                        RuntimeConfigurationBroker.this.info("applied new: " + interceptorsList);
                    }
                }
            });
        } else if (o instanceof DtoPolicyEntry) {
            PolicyEntry addition = this.fromDto(o, new PolicyEntry());
            PolicyMap existingMap = this.getBrokerService().getDestinationPolicy();
            existingMap.put(addition.getDestination(), addition);
            this.applyRetrospectively(addition);
            this.info("added policy for: " + addition.getDestination());
        } else {
            this.info("No runtime support for additions of " + o);
        }
    }

    private VirtualDestination[] fromDto(DtoVirtualDestinationInterceptor virtualDestinationInterceptor) {
        ArrayList<VirtualDestination> answer = new ArrayList<VirtualDestination>();
        for (Object vd : this.filter(virtualDestinationInterceptor, DtoVirtualDestinationInterceptor.VirtualDestinations.class)) {
            for (Object vt : this.filter(vd, DtoVirtualTopic.class)) {
                answer.add(this.fromDto(vt, new VirtualTopic()));
            }
            for (Object vt : this.filter(vd, DtoCompositeTopic.class)) {
                answer.add(this.fromDto(vt, new CompositeTopic()));
            }
            for (Object vt : this.filter(vd, DtoCompositeQueue.class)) {
                answer.add(this.fromDto(vt, new CompositeQueue()));
            }
        }
        VirtualDestination[] array = new VirtualDestination[answer.size()];
        answer.toArray(array);
        return array;
    }

    private <T> T fromDto(Object dto, T instance) {
        Properties properties = new Properties();
        IntrospectionSupport.getProperties(dto, properties, null);
        this.replacePlaceHolders(properties);
        LOG.trace("applying props: " + properties + ", to " + instance.getClass().getSimpleName());
        IntrospectionSupport.setProperties(instance, properties);
        for (Object nested : this.filter(dto, Object.class)) {
            String elementName = nested.getClass().getSimpleName();
            if (elementName.endsWith("s")) {
                Method setter = this.findSetter(instance, elementName);
                if (setter != null) {
                    LinkedList<Object> argument = new LinkedList<Object>();
                    for (Object elementContent : this.filter(nested, Object.class)) {
                        argument.add(this.fromDto(elementContent, this.inferTargetObject(elementContent)));
                    }
                    try {
                        setter.invoke(instance, this.matchType(argument, setter.getParameterTypes()[0]));
                    }
                    catch (Exception e) {
                        this.info("failed to invoke " + setter + " on " + instance, e);
                    }
                    continue;
                }
                this.info("failed to find setter for " + elementName + " on :" + instance);
                continue;
            }
            this.info("unsupported mapping of element for non plural:" + elementName);
        }
        return instance;
    }

    private Object matchType(List<Object> parameterValues, Class<?> aClass) {
        Collection<Object> result = parameterValues;
        if (Set.class.isAssignableFrom(aClass)) {
            result = new HashSet<Object>(parameterValues);
        }
        return result;
    }

    private Object inferTargetObject(Object elementContent) {
        if (DtoTopic.class.isAssignableFrom(elementContent.getClass())) {
            return new ActiveMQTopic();
        }
        if (DtoQueue.class.isAssignableFrom(elementContent.getClass())) {
            return new ActiveMQQueue();
        }
        this.info("update not supported for dto: " + elementContent);
        return new Object();
    }

    private Method findSetter(Object instance, String elementName) {
        String setter = "set" + elementName;
        for (Method m : instance.getClass().getMethods()) {
            if (!setter.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    private <T> List<Object> filter(Object obj, Class<T> type) {
        return this.filter(this.getContents(obj), type);
    }

    private <T> List<Object> filter(List<Object> objectList, Class<T> type) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object o : objectList) {
            if (o instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)o;
                if (!type.isAssignableFrom(element.getDeclaredType())) continue;
                result.add(element.getValue());
                continue;
            }
            if (!type.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return result;
    }

    private DtoBroker loadConfiguration(Resource configToMonitor) {
        DtoBroker jaxbConfig = null;
        if (configToMonitor != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DtoBroker.class});
                Unmarshaller unMarshaller = context.createUnmarshaller();
                unMarshaller.setSchema(this.getSchema());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(configToMonitor.getInputStream());
                Node brokerRootNode = doc.getElementsByTagName("broker").item(0);
                JAXBElement brokerJAXBElement = unMarshaller.unmarshal(brokerRootNode, DtoBroker.class);
                jaxbConfig = (DtoBroker)brokerJAXBElement.getValue();
                this.lastModified = configToMonitor.lastModified();
                this.loadPropertiesPlaceHolderSupport(doc);
            }
            catch (IOException e) {
                this.info("Failed to access: " + configToMonitor, e);
            }
            catch (JAXBException e) {
                this.info("Failed to parse: " + configToMonitor, e);
            }
            catch (ParserConfigurationException e) {
                this.info("Failed to document parse: " + configToMonitor, e);
            }
            catch (SAXException e) {
                this.info("Failed to find broker element in: " + configToMonitor, e);
            }
        }
        return jaxbConfig;
    }

    private void loadPropertiesPlaceHolderSupport(Document doc) {
        BrokerContext brokerContext = this.getBrokerService().getBrokerContext();
        if (brokerContext != null) {
            Properties initialProperties = new Properties(System.getProperties());
            this.placeHolderUtil = new PropertiesPlaceHolderUtil(initialProperties);
            this.mergeProperties(doc, initialProperties);
        }
    }

    private void mergeProperties(Document doc, Properties initialProperties) {
        String resourcesString = "";
        NodeList beans = doc.getElementsByTagName("bean");
        for (int i = 0; i < beans.getLength(); ++i) {
            Node bean = beans.item(0);
            if (!bean.hasAttributes() || !bean.getAttributes().getNamedItem("class").getTextContent().contains("PropertyPlaceholderConfigurer") || !bean.hasChildNodes()) continue;
            NodeList beanProps = bean.getChildNodes();
            for (int j = 0; j < beanProps.getLength(); ++j) {
                Node beanProp = beanProps.item(j);
                if (1 != beanProp.getNodeType() || !beanProp.hasAttributes() || !beanProp.getAttributes().getNamedItem("name").getTextContent().equals("locations")) continue;
                Element beanPropElement = (Element)beanProp;
                NodeList values = beanPropElement.getElementsByTagName("value");
                for (int k = 0; k < values.getLength(); ++k) {
                    Node value = values.item(k);
                    if (!resourcesString.isEmpty()) {
                        resourcesString = resourcesString + ",";
                    }
                    resourcesString = resourcesString + value.getFirstChild().getTextContent();
                }
            }
        }
        LinkedList<Resource> propResources = new LinkedList<Resource>();
        for (String value : resourcesString.split(",")) {
            try {
                if (value.isEmpty()) continue;
                propResources.add(Utils.resourceFromString(this.replacePlaceHolders(value)));
            }
            catch (MalformedURLException e) {
                this.info("failed to resolve resource: " + value, e);
            }
        }
        for (Resource resource : propResources) {
            Properties properties = new Properties();
            try {
                properties.load(resource.getInputStream());
            }
            catch (IOException e) {
                this.info("failed to load properties resource: " + resource, e);
            }
            initialProperties.putAll((Map<?, ?>)properties);
        }
    }

    private void replacePlaceHolders(Properties properties) {
        if (this.placeHolderUtil != null) {
            this.placeHolderUtil.filter(properties);
        }
    }

    private String replacePlaceHolders(String s) {
        if (this.placeHolderUtil != null) {
            s = this.placeHolderUtil.filter(s);
        }
        return s;
    }

    private Schema getSchema() throws SAXException, IOException {
        if (this.schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
            schemas.add(new StreamSource(this.getClass().getResource("/activemq.xsd").toExternalForm()));
            PluggableSchemaResolver springResolver = new PluggableSchemaResolver(this.getClass().getClassLoader());
            InputSource beanInputSource = springResolver.resolveEntity("http://www.springframework.org/schema/beans", "http://www.springframework.org/schema/beans/spring-beans.xsd");
            if (beanInputSource != null) {
                schemas.add(new StreamSource(beanInputSource.getByteStream()));
            } else {
                schemas.add(new StreamSource("http://www.springframework.org/schema/beans/spring-beans.xsd"));
            }
            this.schema = schemaFactory.newSchema(schemas.toArray(new Source[0]));
        }
        return this.schema;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Resource getConfigToMonitor() {
        return this.configToMonitor;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public static class PropertiesPlaceHolderUtil {
        static final Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        final Properties properties;
        static Pattern[] byteMatchers = new Pattern[]{Pattern.compile("^\\s*(\\d+)\\s*(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2), Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2)};

        public PropertiesPlaceHolderUtil(Properties properties) {
            this.properties = properties;
        }

        public void filter(Properties toFilter) {
            for (Map.Entry<Object, Object> entry : toFilter.entrySet()) {
                String newVal;
                String val = (String)entry.getValue();
                if (val.equals(newVal = this.filter(val))) continue;
                toFilter.put(entry.getKey(), newVal);
            }
        }

        public String filter(String str) {
            Matcher matcher;
            int start2 = 0;
            while ((matcher = pattern.matcher(str)).find(start2)) {
                String group = matcher.group(1);
                String property = this.properties.getProperty(group);
                if (property != null) {
                    str = matcher.replaceFirst(Matcher.quoteReplacement(property));
                    continue;
                }
                start2 = matcher.end();
            }
            return this.replaceBytePostfix(str);
        }

        private String replaceBytePostfix(String str) {
            try {
                for (int i = 0; i < byteMatchers.length; ++i) {
                    Matcher matcher = byteMatchers[i].matcher(str);
                    if (!matcher.matches()) continue;
                    long value = Long.parseLong(matcher.group(1));
                    for (int j = 1; j <= i; ++j) {
                        value *= 1024L;
                    }
                    return String.valueOf(value);
                }
            }
            catch (NumberFormatException ignored) {
                LOG.debug("nfe on: " + str, (Throwable)ignored);
            }
            return str;
        }
    }
}

