/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.CompositeReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public interface ReadableBuffer {
    public int capacity();

    public boolean hasArray();

    public byte[] array();

    public int arrayOffset();

    public ReadableBuffer reclaimRead();

    public byte get();

    public byte get(int var1);

    public int getInt();

    public long getLong();

    public short getShort();

    public float getFloat();

    public double getDouble();

    public ReadableBuffer get(byte[] var1, int var2, int var3);

    public ReadableBuffer get(byte[] var1);

    public ReadableBuffer get(WritableBuffer var1);

    public ReadableBuffer slice();

    public ReadableBuffer flip();

    public ReadableBuffer limit(int var1);

    public int limit();

    public ReadableBuffer position(int var1);

    public int position();

    public ReadableBuffer mark();

    public ReadableBuffer reset();

    public ReadableBuffer rewind();

    public ReadableBuffer clear();

    public int remaining();

    public boolean hasRemaining();

    public ReadableBuffer duplicate();

    public ByteBuffer byteBuffer();

    public String readUTF8() throws CharacterCodingException;

    public String readString(CharsetDecoder var1) throws CharacterCodingException;

    public static final class ByteBufferReader
    implements ReadableBuffer {
        private ByteBuffer buffer;

        public static ByteBufferReader allocate(int size2) {
            ByteBuffer allocated = ByteBuffer.allocate(size2);
            return new ByteBufferReader(allocated);
        }

        public static ByteBufferReader wrap(ByteBuffer buffer) {
            return new ByteBufferReader(buffer);
        }

        public static ByteBufferReader wrap(byte[] array) {
            return new ByteBufferReader(ByteBuffer.wrap(array));
        }

        public ByteBufferReader(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int capacity() {
            return this.buffer.capacity();
        }

        @Override
        public byte get() {
            return this.buffer.get();
        }

        @Override
        public byte get(int index) {
            return this.buffer.get(index);
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }

        @Override
        public short getShort() {
            return this.buffer.getShort();
        }

        @Override
        public float getFloat() {
            return this.buffer.getFloat();
        }

        @Override
        public double getDouble() {
            return this.buffer.getDouble();
        }

        @Override
        public int limit() {
            return this.buffer.limit();
        }

        @Override
        public ReadableBuffer get(byte[] data, int offset, int length) {
            this.buffer.get(data, offset, length);
            return this;
        }

        @Override
        public ReadableBuffer get(byte[] data) {
            this.buffer.get(data);
            return this;
        }

        @Override
        public ReadableBuffer flip() {
            this.buffer.flip();
            return this;
        }

        @Override
        public ReadableBuffer position(int position) {
            this.buffer.position(position);
            return this;
        }

        @Override
        public ReadableBuffer slice() {
            return new ByteBufferReader(this.buffer.slice());
        }

        @Override
        public ReadableBuffer limit(int limit) {
            this.buffer.limit(limit);
            return this;
        }

        @Override
        public int remaining() {
            return this.buffer.remaining();
        }

        @Override
        public int position() {
            return this.buffer.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        @Override
        public ReadableBuffer duplicate() {
            return new ByteBufferReader(this.buffer.duplicate());
        }

        @Override
        public ByteBuffer byteBuffer() {
            return this.buffer;
        }

        @Override
        public String readUTF8() {
            return StandardCharsets.UTF_8.decode(this.buffer).toString();
        }

        @Override
        public String readString(CharsetDecoder decoder) throws CharacterCodingException {
            return decoder.decode(this.buffer).toString();
        }

        @Override
        public boolean hasArray() {
            return this.buffer.hasArray();
        }

        @Override
        public byte[] array() {
            return this.buffer.array();
        }

        @Override
        public int arrayOffset() {
            return this.buffer.arrayOffset();
        }

        @Override
        public ReadableBuffer reclaimRead() {
            return this;
        }

        @Override
        public ReadableBuffer mark() {
            this.buffer.mark();
            return this;
        }

        @Override
        public ReadableBuffer reset() {
            this.buffer.reset();
            return this;
        }

        @Override
        public ReadableBuffer rewind() {
            this.buffer.rewind();
            return this;
        }

        @Override
        public ReadableBuffer clear() {
            this.buffer.clear();
            return this;
        }

        @Override
        public ReadableBuffer get(WritableBuffer target) {
            target.put(this.buffer);
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }

        public int hashCode() {
            return this.buffer.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadableBuffer)) {
                return false;
            }
            ReadableBuffer readable = (ReadableBuffer)other;
            if (this.remaining() != readable.remaining()) {
                return false;
            }
            if (other instanceof CompositeReadableBuffer) {
                return other.equals(this);
            }
            return this.buffer.equals(readable.byteBuffer());
        }
    }
}

