/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.Service;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.http.BlockingQueueTransport;
import org.apache.activemq.transport.http.HttpTransportFactory;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTunnelServlet
extends HttpServlet {
    private static final long serialVersionUID = -3826714430767484333L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpTunnelServlet.class);
    private TransportAcceptListener listener;
    private HttpTransportFactory transportFactory;
    private TextWireFormat wireFormat;
    private ConcurrentMap<String, BlockingQueueTransport> clients = new ConcurrentHashMap<String, BlockingQueueTransport>();
    private final long requestTimeout = 30000L;
    private HashMap<String, Object> transportOptions;
    private HashMap<String, Object> wireFormatOptions;

    public void init() throws ServletException {
        super.init();
        this.listener = (TransportAcceptListener)this.getServletContext().getAttribute("acceptListener");
        if (this.listener == null) {
            throw new ServletException("No such attribute 'acceptListener' available in the ServletContext");
        }
        this.transportFactory = (HttpTransportFactory)this.getServletContext().getAttribute("transportFactory");
        if (this.transportFactory == null) {
            throw new ServletException("No such attribute 'transportFactory' available in the ServletContext");
        }
        this.transportOptions = (HashMap)this.getServletContext().getAttribute("transportOptions");
        this.wireFormatOptions = (HashMap)this.getServletContext().getAttribute("wireFormatOptions");
        this.wireFormat = (TextWireFormat)this.getServletContext().getAttribute("wireFormat");
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader("Accepts-Encoding", "gzip");
        super.doOptions(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.createTransportChannel(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Command packet = null;
        int count = 0;
        try {
            BlockingQueueTransport transportChannel = this.getTransportChannel(request, response);
            if (transportChannel == null) {
                return;
            }
            packet = (Command)transportChannel.getQueue().poll(30000L, TimeUnit.MILLISECONDS);
            DataOutputStream stream = new DataOutputStream((OutputStream)response.getOutputStream());
            this.wireFormat.marshal(packet, stream);
            ++count;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (count == 0) {
            response.setStatus(408);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Command command;
        if (this.wireFormatOptions.get("maxFrameSize") != null && request.getContentLength() > Integer.parseInt(this.wireFormatOptions.get("maxFrameSize").toString())) {
            response.setStatus(405);
            response.setContentType("plain/text");
            PrintWriter writer = response.getWriter();
            writer.println("maxFrameSize exceeded");
            writer.flush();
            writer.close();
            return;
        }
        Object stream = request.getInputStream();
        String contentType = request.getContentType();
        if (contentType != null && contentType.equals("application/x-gzip")) {
            stream = new GZIPInputStream((InputStream)stream);
        }
        if ((command = (Command)this.wireFormat.unmarshalText(new InputStreamReader((InputStream)stream, "UTF-8"))) instanceof WireFormatInfo) {
            WireFormatInfo info = (WireFormatInfo)command;
            if (!this.canProcessWireFormatVersion(info.getVersion())) {
                response.sendError(404, "Cannot process wire format of version: " + info.getVersion());
            }
        } else {
            BlockingQueueTransport transport = this.getTransportChannel(request, response);
            if (transport == null) {
                return;
            }
            if (command instanceof ConnectionInfo) {
                ((ConnectionInfo)command).setTransportContext(request.getAttribute("javax.servlet.request.X509Certificate"));
            }
            transport.doConsume(command);
        }
    }

    private boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    protected String readRequestBody(HttpServletRequest request) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected BlockingQueueTransport getTransportChannel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String clientID = request.getHeader("clientID");
        if (clientID == null) {
            response.sendError(400, "No clientID header specified");
            LOG.warn("No clientID header specified");
            return null;
        }
        BlockingQueueTransport answer = (BlockingQueueTransport)this.clients.get(clientID);
        if (answer == null) {
            LOG.warn("The clientID header specified is invalid. Client sesion has not yet been established for it: " + clientID);
            return null;
        }
        return answer;
    }

    protected BlockingQueueTransport createTransportChannel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        final String clientID = request.getHeader("clientID");
        if (clientID == null) {
            response.sendError(400, "No clientID header specified");
            LOG.warn("No clientID header specified");
            return null;
        }
        BlockingQueueTransport answer = this.createTransportChannel();
        if (this.clients.putIfAbsent(clientID, answer) != null) {
            response.sendError(400, "A session for the given clientID has already been established");
            LOG.warn("A session for clientID '" + clientID + "' has already been established");
            return null;
        }
        answer.addServiceListener(new ServiceListener(){

            @Override
            public void started(Service service) {
            }

            @Override
            public void stopped(Service service) {
                HttpTunnelServlet.this.clients.remove(clientID);
            }
        });
        Transport transport = answer;
        try {
            HashMap<String, Object> options = new HashMap<String, Object>(this.transportOptions);
            transport = this.transportFactory.serverConfigure(answer, null, options);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
        this.listener.onAccept(transport);
        while (!transport.isConnected() && !transport.isDisposed()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (transport.isDisposed()) {
            response.sendError(400, "The session for the given clientID was prematurely disposed");
            LOG.warn("The session for clientID '" + clientID + "' was prematurely disposed");
            return null;
        }
        return answer;
    }

    protected BlockingQueueTransport createTransportChannel() {
        return new BlockingQueueTransport(new LinkedBlockingQueue<Object>());
    }

    protected TextWireFormat createWireFormat() {
        return new XStreamWireFormat();
    }
}

