/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.linkedin.util.reflect.ReflectUtils;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    private final ClassLoader _classLoader;

    public ObjectInputStreamWithClassLoader(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this._classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return ReflectUtils.forName(osc.getName(), this._classLoader);
    }
}

