/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.qpid.proton.ProtonException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.MapType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.StringType;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.ApplicationPropertiesType;

public class FastPathApplicationPropertiesType
implements AMQPType<ApplicationProperties>,
FastPathDescribedTypeConstructor<ApplicationProperties> {
    private static final byte DESCRIPTOR_CODE = 116;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(116L), Symbol.valueOf("amqp:application-properties:map")};
    private final ApplicationPropertiesType propertiesType;
    private final StringType stringType;

    public FastPathApplicationPropertiesType(EncoderImpl encoder) {
        this.propertiesType = new ApplicationPropertiesType(encoder);
        this.stringType = (StringType)encoder.getTypeFromClass(String.class);
    }

    public EncoderImpl getEncoder() {
        return this.propertiesType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.propertiesType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<ApplicationProperties> getTypeClass() {
        return ApplicationProperties.class;
    }

    @Override
    public TypeEncoding<ApplicationProperties> getEncoding(ApplicationProperties val) {
        return this.propertiesType.getEncoding(val);
    }

    @Override
    public TypeEncoding<ApplicationProperties> getCanonicalEncoding() {
        return this.propertiesType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<ApplicationProperties>> getAllEncodings() {
        return this.propertiesType.getAllEncodings();
    }

    @Override
    public ApplicationProperties readValue() {
        int count;
        DecoderImpl decoder = this.getDecoder();
        ReadableBuffer buffer = decoder.getBuffer();
        byte encodingCode = buffer.get();
        switch (encodingCode) {
            case -63: {
                int size2 = buffer.get() & 0xFF;
                count = buffer.get() & 0xFF;
                break;
            }
            case -47: {
                int size2 = buffer.getInt();
                count = buffer.getInt();
                break;
            }
            case 64: {
                return new ApplicationProperties(null);
            }
            default: {
                throw new ProtonException("Expected Map type but found encoding: " + encodingCode);
            }
        }
        if (count > buffer.remaining()) {
            throw new IllegalArgumentException("Map element count " + count + " is specified to be greater than the amount of data available (" + buffer.remaining() + ")");
        }
        TypeConstructor<?> valueConstructor = null;
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            String key = decoder.readString(null);
            if (key == null) {
                throw new DecodeException("String key in ApplicationProperties cannot be null");
            }
            boolean arrayType = false;
            byte code = buffer.get(buffer.position());
            switch (code) {
                case -32: 
                case -16: {
                    arrayType = true;
                }
            }
            valueConstructor = FastPathApplicationPropertiesType.findNextDecoder(decoder, buffer, valueConstructor);
            Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
            map2.put(key, value);
        }
        return new ApplicationProperties(map2);
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(ApplicationProperties val) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)116);
        MapType mapType = (MapType)this.getEncoder().getType(val.getValue());
        mapType.setKeyEncoding(this.stringType);
        mapType.write(val.getValue());
        mapType.setKeyEncoding(null);
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathApplicationPropertiesType type = new FastPathApplicationPropertiesType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    private static TypeConstructor<?> findNextDecoder(DecoderImpl decoder, ReadableBuffer buffer, TypeConstructor<?> previousConstructor) {
        if (previousConstructor == null) {
            return decoder.readConstructor();
        }
        byte encodingCode = buffer.get(buffer.position());
        if (encodingCode == 0 || !(previousConstructor instanceof PrimitiveTypeEncoding)) {
            previousConstructor = decoder.readConstructor();
        } else {
            PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)previousConstructor;
            if (encodingCode != primitiveConstructor.getEncodingCode()) {
                previousConstructor = decoder.readConstructor();
            } else {
                byte by = buffer.get();
            }
        }
        if (previousConstructor == null) {
            throw new DecodeException("Unknown constructor found in Map encoding: ");
        }
        return previousConstructor;
    }
}

