/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import org.linkedin.zookeeper.client.AbstractZKClient;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.LifecycleListener;

public class ChrootedZKClient
extends AbstractZKClient
implements IZKClient {
    private final IZKClient _zkClient;

    public ChrootedZKClient(IZKClient zkClient, String chroot) {
        super(chroot);
        this._zkClient = zkClient;
    }

    protected IZooKeeper getZk() {
        return this._zkClient;
    }

    public IZKClient chroot(String path) {
        return new ChrootedZKClient(this._zkClient, this.adjustPath(path));
    }

    public boolean isConnected() {
        return this._zkClient.isConnected();
    }

    public void registerListener(LifecycleListener listener) {
        this._zkClient.registerListener(listener);
    }

    public void removeListener(LifecycleListener listener) {
        this._zkClient.removeListener(listener);
    }

    public String getConnectString() {
        return this._zkClient.getConnectString();
    }
}

