/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.JarResource;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.LeafResource;
import org.linkedin.util.io.resource.internal.LocalCacheLeafResource;
import org.linkedin.util.io.resource.internal.PathBasedResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResourceProvider
extends PathBasedResourceProvider {
    public static final String MODULE = JarResourceProvider.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final LeafResource _jarResource;

    public JarResourceProvider(Resource jarResource) {
        this(jarResource, "/");
    }

    public JarResourceProvider(Resource jarResource, String root) {
        super(root);
        this._jarResource = LocalCacheLeafResource.create(jarResource);
    }

    private JarResourceProvider(LeafResource jarResource, String root) {
        super(root);
        this._jarResource = jarResource;
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        return new JarResourceProvider(this._jarResource, this.getFullPath(rootPath));
    }

    @Override
    public InternalResource doBuildResource(String path) {
        return new JarResource(this, path, this._jarResource, this.getFullPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doList(String path, ResourceFilter filter) {
        boolean bl;
        JarFile jarFile = new JarFile(this._jarResource.getFile());
        try {
            bl = this.doList(path, filter, jarFile);
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug("exception (ignored) while listing path " + path, (Throwable)e);
                }
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    private boolean doList(String path, ResourceFilter filter, JarFile jarFile) {
        String directory = PathUtils.removeLeadingSlash(this.getFullPath(path));
        boolean isDirectory = false;
        Enumeration<JarEntry> iter = jarFile.entries();
        while (iter.hasMoreElements()) {
            int idx;
            JarEntry entry = iter.nextElement();
            String entryName = entry.getName();
            if (entryName.equals(directory)) {
                isDirectory = true;
                continue;
            }
            if (!entryName.startsWith(directory) || (idx = entryName.indexOf("/", directory.length())) != -1 && idx != entryName.length() - 1) continue;
            isDirectory = true;
            JarResource resource = new JarResource(this, this.getRelativePath(PathUtils.addLeadingSlash(entryName)), this._jarResource, entryName);
            filter.accept(resource);
        }
        return isDirectory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JarResourceProvider that = (JarResourceProvider)o;
        return this._jarResource.equals(that._jarResource);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._jarResource.hashCode();
        return result;
    }
}

